
<?php $__env->startSection('title', 'Registrations'); ?>

<?php $__env->startSection('page-header'); ?>
				<!-- breadcrumb -->
				<div class="breadcrumb-header justify-content-between">
					<div class="my-auto">
						<div class="d-flex">
							<h4 class="content-title mb-0 my-auto">Dashboard</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ Registrations</span>
						</div>
					</div>
				</div>
				<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

		<div class="loader-container hidden">
			<div class="spinner-border"></div>
		</div>

		<!-- row opened -->
		<div class="row row-sm">
			<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Registrations TABLE - <span class="text-primary">Counter (<?php echo e($all_records_count); ?>)</span></h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">

						<!-- Start Filter -->
						<div class="filter-box">
							<form action="<?php echo e(route('bookings.index', ['page'=>1])); ?>" method="GET">
		
								<input type="hidden" name="page" value="1">
								<input type="hidden" name="filter" value="1">
					
								<div class="row bg-white pt-4">
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control" name="contact_person" placeholder="contact person">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="number" class="form-control" name="mobile" placeholder="Mobile">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control" name="company" placeholder="Company">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control" name="creation_src" placeholder="Register From">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control date" name="created_at" placeholder="Booking Date">
										</div>
									</div>
		
								</div>

								<div class="row pb-4">
									<div class="col-6 col-lg-2">
										<div class="form-group">
											<button type="submit" class="btn btn-primary" style="width: 100%"><i class="fa-solid fa-magnifying-glass"></i> Filter</button>
										</div>
									</div>
									<div class="col-6 col-lg-2">
										<div class="form-group">
											<a href="<?php echo e(route('bookings.index')); ?>" class="btn btn-danger" style="width: 100%"><i class="fa-solid fa-circle-xmark"></i> Clear</a>
										</div>
									</div>
									<div class="col-6 col-lg-2">
										<div class="form-group">
											<a href="<?php echo e(route('bookings.index', ['page' => 1, 'last_record' => 'true'])); ?>" class="btn btn-success" style="width: 100%"><i class="fa-solid fa-user"></i> Last Record</a>
										</div>
									</div>
									<?php if(auth()->user()->role == 'admin'): ?>
									<div class="col-6 col-lg-2">
										<div class="form-group">
											<a href="<?php echo e(route('bookings_export', ['records_ids' => json_encode($records_ids)])); ?>" class="btn btn-dark" style="width: 100%"><i class="fa-solid fa-download"></i> Export</a>
										</div>
									</div>
									<?php endif; ?>
								</div>
						
							</form>
						</div>
						<!-- End Filter -->

					</div>
				</div>
			</div>

			<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Registrations TABLE</h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">

						<?php if(auth()->user()->role == 'admin'): ?>
							
						<div class="row pb-3">
							<div class="col-6 col-lg-2">
								<div class="form-group">
									<a href="#" id="select-all" class="btn btn-dark font-size-13" style="width: 100%"><i class="fa-solid fa-list-check"></i> Select ALL</a>
								</div>
							</div>
							<div class="col-6 col-lg-2">
								<div class="form-group">
									<a href="#" id="delete-records" class="btn btn-dark font-size-13" style="width: 100%"><i class="fa-solid fa-trash-can"></i> Delete Records</a>
								</div>
							</div>
							<div class="col-6 col-lg-2">
								<div class="form-group">
									<a href="#" id="print-records" class="btn btn-dark font-size-13" style="width: 100%"><i class="fa-solid fa-print"></i> Print Records</a>
								</div>
							</div>
							<div class="col-6 col-lg-2">
								<div class="form-group">
									<a href="#" id="export-selected-records" class="btn btn-dark font-size-13" style="width: 100%"><i class="fa-solid fa-download"></i>Export Records</a>
								</div>
							</div>
							<div class="col-6 col-lg-2">
								<div class="form-group">
									<a href="#" id="erase-db" class="btn btn-dark font-size-13" style="width: 100%"><i class="fa-solid fa-eraser"></i>Erase database</a>
								</div>
							</div>
						</div>

						<form action="<?php echo e(route('bookings_export')); ?>" method="GET" id="export-form">
							<input type="hidden" name="records_ids">
						</form>

						<?php endif; ?>

						<!-- Start Table -->
						<div class="table-responsive">
							<table class="table text-md-nowrap" id="example1">
								<thead>
									<tr>
										<th class="all border-bottom-0">#</th>
										<th class="all"></th>
										<th class="all border-bottom-0">contact_person</th>
										<th class="all border-bottom-0">company</th>
										<th class="all border-bottom-0">title</th>
										<th class="all border-bottom-0">mobile</th>
										<th class="all border-bottom-0">Register From</th>
										<th class="all border-bottom-0">Admin/Usher</th>
										<th class="all border-bottom-0">date</th>
										<th class="all border-bottom-0">Action</th>
									</tr>
								</thead>
								<tbody>
									<?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($booking->id); ?></td>
										<td><input type="checkbox" class="record-checkbox" data-id="<?php echo e($booking->id); ?>" name="id"></td>
										<td><?php echo e($booking->contact_person); ?></td>
										<td><?php echo e($booking->company); ?></td>
										<td><?php echo e($booking->title); ?></td>
										<td><?php echo e($booking->mobile); ?></td>
										<td><?php echo e($booking->creation_src); ?></td>
										<td>
											<?php if(isset($booking->user)): ?>
												<a href="#" class="text-dark"><?php echo e($booking->user->name); ?></a>
											<?php endif; ?>
										</td>
										<td><?php echo e(date('d M Y', strtotime($booking->created_at))); ?></td>
										<td>
											<?php if(auth()->user()->role == 'admin'): ?>
											<a href="#" class="deleteRow mx-1" data-id="<?php echo e($booking->id); ?>"><i class="fa-solid fa-trash text-danger"></i></a>
											<?php endif; ?>
											<a href="bookings/<?php echo e($booking->id); ?>" class="mx-1"><i class="fa-solid fa-pen-to-square"></i></a>
											<a href="#" data-id="<?php echo e($booking->id); ?>" data-type="badge" class="print-ticket mx-1"><i class="fa-solid fa-print text-success" title="Print Badge"></i></a>
											<a href="#" data-id="<?php echo e($booking->id); ?>" data-type="label" class="print-ticket mx-1"><i class="fa-solid fa-print text-info" title="Print Label"></i></a>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
						<!-- End Table -->



						<!-- Start Pagination -->
						<?php if(count($bookings) > 0): ?>
		
						<div class="text-center text-md-left font-size-14 mb-3 text-lh-1">Showing <?php echo e($page); ?>–<?php echo e($num_of_pages); ?></div>
						<nav aria-label="Page navigation" id="pagiantionNav">
							<ul class="list-pagination-1 pagination border border-color-4 rounded-sm mb-5 mb-lg-0 overflow-auto overflow-xl-visible justify-content-md-center align-items-center py-2">
								
								<li class="page-item <?php echo e($page==1 ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="1" aria-label="Previous" title="Start">
										<i class="fa-solid fa-angles-left"></i>
									</a>
								</li>
								<li class="page-item <?php echo e($page==1 ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($page-1); ?>" aria-label="Previous">
										<i class="fa-solid fa-angle-left" title="Previous"></i>
									</a>
								</li>
		
								<?php
									if($page < 11) {
										$pagination_start = 1;
									} else {
										$pagination_start = ((int) ($page / 10)) * 10;
									}
								?>
		
								<?php for($page_count = $pagination_start, $i=1; $page_count <= $num_of_pages; $page_count++, $i++): ?>
		
								<?php if ($i>10) { break;} ?>
		
								<li class="page-item <?php echo e($page==$page_count ? 'active disabled-link' : ''); ?>">
									<a class="page-link font-size-14 text-dark <?php echo e($page==$page_count ? 'text-white' : ''); ?>" href="#" data-page="<?php echo e($page_count); ?>"><?php echo e($page_count); ?></a>
								</li>
								
								<?php endfor; ?>
		
								<li class="page-item <?php echo e($page==$num_of_pages ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($page+1); ?>" aria-label="Next">
										<i class="fa-solid fa-angle-right" title="Next"></i>
									</a>
								</li>
								<li class="page-item <?php echo e($page==$num_of_pages ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($num_of_pages); ?>" aria-label="Next" title="End">
										<i class="fa-solid fa-angles-right"></i>
									</a>
								</li>
								
							</ul>
						</nav>
		
						<?php endif; ?>
						<!-- End Pagination -->


					</div>
				</div>
			</div>
			<!--/div-->
		</div>
		<!-- /row -->
	</div>
	<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>

<script>

	function pagination($this) {
		var page = $this.data('page');

		var params = new URLSearchParams(location.search);
		params.set('page', page);
		window.location.search = params.toString();

	}

	function toggleCheckAll() {
		var allChecked = $('.record-checkbox:checked').length === $('.record-checkbox').length;
		if (allChecked) {
			$('.record-checkbox').prop('checked', false);
		} else {
			$('.record-checkbox').prop('checked', true);
		}
	}

	function checkIfAllSelected() {
		var allChecked = $('.record-checkbox:checked').length === $('.record-checkbox').length;
		$('#select-all').prop('checked', allChecked);
	}

	function getSelectedIds() {
		var ids = $('.record-checkbox:checked').map(function() {
			return $(this).data('id');
		}).get();

		return ids;
	}

	function deleteRecords() {

		var ids = getSelectedIds();

		if (ids.length === 0) {
			swalAlert('No records are selected.', '' ,0);
		} else {

			var ajaxPromise = ajaxRequest('POST', "<?php echo e(route('bookings_delete_records')); ?>", { ids: ids });

			ajaxPromise.done(function(response) {
				swalAlert(response.message, '' ,response.status);
			});

			ajaxPromise.fail(function(xhr, status, error) {
				swalAlert('Request failed', '' ,0);
				console.log('Request failed:', error);
			});
		}

	}

	function deleteRecord(deleted_id) {

		var ajaxPromise = ajaxRequest('POST', "<?php echo e(Url('admin/delete/booking')); ?>", {deleted_id: deleted_id});

		ajaxPromise.done(function(response) {
			swalAlert(response.message, '' ,response.status);
		});

		ajaxPromise.fail(function(xhr, status, error) {
			swalAlert('Request failed', '' ,0);
			console.log('Request failed:', error);
		});

	}

	function exportRecords() {

		var ids = getSelectedIds();

		if (ids.length === 0) {
			swalAlert('No records are selected.', '' ,0);
		} else {

			$('#export-form input[name="records_ids"]').val(JSON.stringify(ids));
			$('#export-form').submit();

		}

	}

	function erase_db() {

		var ajaxPromise = ajaxRequest('POST', "<?php echo e(route('erase_db')); ?>", '');

		ajaxPromise.done(function(response) {
			swalAlert(response.message, '' ,response.status);
		});

		ajaxPromise.fail(function(xhr, status, error) {
			swalAlert('Request failed', '' ,0);
			console.log('Request failed:', error);
		});

	}

	function confirmDeleteRecord(deleted_id) {
		return function() {
			deleteRecord(deleted_id);
		};
	}

	function print_records() {

		var ids = getSelectedIds();

		if (ids.length === 0) {

			swalAlert('No records are selected.', '' ,0);

		} else {

			var ajaxPromise = ajaxRequest('POST', "<?php echo e(route('print_ticket')); ?>", {records_ids: ids, print_type: 'label'});

			ajaxPromise.done(function(response) {
				if(response.status == 1) {
					var print_url = response.message;
					printTickets(print_url, 'label');

				} else {
					swalAlert('Request failed', '' ,0);
				}

			});

			ajaxPromise.fail(function(xhr, status, error) {
				swalAlert('Request failed', '' ,0);
				console.log('Request failed:', error);
			});
		}

		
	}
		

	$(document).ready(function() {
		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			} 
		});




		// ********* Start Test
		const data = {
			token: "aqw2345@bcrwty87vnm",
			customerData: {
				customer_id: 1,
				firstName: "Mohamed",
				lastName: "Emad",
				email: "mo.emaad07@gmail.com",
				phone: "01157949731",
			},
			orderData: {
				triptype: "roundtrip",
				cabin: "economy",
				adults: 1,
				childrenCount: 1,
				infantsCount: 1,
				totalAmount: 1555.0,
				airlines: ["Emirates"],
			},
			departFlight: {
				tripId: "DFW-CAI:AC899411:AC7411:1",
				departureCity: "Cairo",
				arrivalCity: "Barcelona",
				departureAirport: "CAI",
				arrivalAirport: "CAI",
				departureTime: "19:05",
				arrivalTime: "19:05",
				duration: "21h 45m",
				stopoversCount: "1",
				departureDateTime: "2022-10-04",
				arrivalDateTime: "2022-10-04",
			},
			returnFlight: {
				tripId: "DFW-CAI:AC899411:AC74~11:1",
				departureCity: "Barcelona",
				arrivalCity: "Cairo",
				departureAirport: "CAI",
				arrivalAirport: "CAI",
				departureTime: "19:05",
				arrivalTime: "19:05",
				duration: "21h 45m",
				stopoversCount: "1",
				departureDateTime: "2022-10-04",
				arrivalDateTime: "2022-10-04",
			},
		};

		fetch("https://jointravel.com.sa/api/insertFlightRequest", {
			method: "POST",
			headers: {
				"Content-Type": "application/json",
			},
			body: JSON.stringify(data),
			})
			.then((response) => {
				console.log("Response:", response);
			})
			.catch((error) => {
				console.error("Error:", error);
		});
		// ********* End Test





		$("input.date").focus(function() {
			$(this).attr("type", "date");
		});

		// Delete record
		$('.deleteRow').on('click', function(e) {
			e.preventDefault();
			var deleted_id = $(this).data('id');
			swalWithConfirm(confirmDeleteRecord(deleted_id));
		});

		// *** Pagination
		$('#pagiantionNav .page-link').on('click', function(e) {
			e.preventDefault();
			pagination($(this));
		});

		// Toggle Check all
		$('#select-all').on('click', function(e) {
			e.preventDefault();
			toggleCheckAll();
		});

		$('.record-checkbox').change(function() {
			checkIfAllSelected();
		});

		// Delete Multible Records
		$('#delete-records').on('click', function(e) {
			e.preventDefault();
			swalWithConfirm(deleteRecords);
		});

		// Erase DB
		$('#erase-db').on('click', function(e) {
			e.preventDefault();
			swalWithConfirm(erase_db);
		});

		// Print Multible Records
		$('#print-records').on('click', function(e) {
			e.preventDefault();
			swalWithConfirm(print_records);
		});

		// Export Selected Records
		$('#export-selected-records').on('click', function(e) {
			e.preventDefault();
			swalWithConfirm(exportRecords);
		});

		

	});



</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\hvac_admin\resources\views/bookings/index.blade.php ENDPATH**/ ?>