
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($activity) ? 'Edit activity': 'Add activity'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">activity</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($activity) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- activity form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($activity) ? Route('activities.update', ['activity'=>$activity->id]) : Route('activities.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="type_id">Activity Type</label>
							<select name="type_id" id="type_id" class="form-control" required>
								<option value="" disabled selected>Choose Type</option>
								<?php $type_id = isset($activity) ? $activity->type_id : ''; ?>
								<?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($type->id); ?>" <?php echo e($type_id == $type->id ? 'selected': ''); ?>><?php echo e($type->name); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('type_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('type_id')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="category_id">Category</label>
							<select name="category_id" id="category_id" class="form-control" required>
								<option value="" disabled selected>Choose Category</option>
								<?php $category_id = isset($activity) ? $activity->category_id : ''; ?>
								<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($category->id); ?>" <?php echo e($category_id == $category->id ? 'selected': ''); ?>><?php echo e($category->name); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('category_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('category_id')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($activity) ? $activity->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="overview">overview</label>
							<input type="text" class="form-control" name="overview" id="overview" required value="<?php echo e(isset($activity) ? $activity->overview : old('overview')); ?>" placeholder="Enter overview">
							<?php if($errors->has('overview')): ?>
								<p class="help text-danger"><?php echo e($errors->first('overview')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea name="description" id="editor" rows="10" class="form-control">
								<?php echo e(isset($activity) ? $activity->description : old('description')); ?>

							</textarea>
							<?php if($errors->has('description')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="difficulty">Difficulty</label>
							<select name="difficulty" id="difficulty" class="form-control" required>
								<option value="" disabled selected>Choose Difficulty</option>
								<?php $difficulty = isset($activity) ? $activity->difficulty : ''; ?>
								<option value="Beginner" <?php echo e($difficulty == "Beginner" ? 'selected': ''); ?>>Beginner</option>
								<option value="Intermediate" <?php echo e($difficulty == "Intermediate" ? 'selected': ''); ?>>Intermediate</option>
								<option value="Advanced" <?php echo e($difficulty == "Advanced" ? 'selected': ''); ?>>Advanced</option>
							</select>
							<?php if($errors->has('difficulty')): ?>
								<p class="help text-danger"><?php echo e($errors->first('difficulty')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="duration">duration (in seconds)</label>
							<input type="number" class="form-control" name="duration" id="duration" min="30" max="7200" required value="<?php echo e(isset($activity) ? $activity->duration : old('duration')); ?>" placeholder="Enter duration">
							<?php if($errors->has('duration')): ?>
								<p class="help text-danger"><?php echo e($errors->first('duration')); ?></p>
							<?php endif; ?>
						</div>

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="main_image" accept="image/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($activity)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(config('app.uploads')); ?><?php echo e($activity->main_image); ?>"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($activity->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('main_image')): ?>
											<p class="help text-danger"><?php echo e($errors->first('main_image')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->



						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($activity) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- activity form END -->
		
		<?php if(isset($activity)): ?>
		<!-- assign exercise form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
			    
			    <div class="card-title ml-3">
			        Assign Exercise To (<?php echo e($activity->title); ?>)
		        </div>
		        
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(Route('assign_activity_exercise')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						
						<input type="hidden" name="activity_id" value="<?php echo e($activity->id); ?>">
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="exercise_id">Exercise</label>
							<select name="exercise_id" id="exercise_id" class="form-control" required>
								<option value="" disabled selected>Choose exercise</option>
								<?php $__currentLoopData = $exercises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exercise): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($exercise->id); ?>"><?php echo e($exercise->title); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('exercise_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('exercise_id')); ?></p>
							<?php endif; ?>
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="reps">reps</label>
							<input type="number" class="form-control" name="reps" id="reps" required value="<?php echo e(isset($activity) ? $activity->reps : old('reps')); ?>" placeholder="Enter reps">
							<?php if($errors->has('reps')): ?>
								<p class="help text-danger"><?php echo e($errors->first('reps')); ?></p>
							<?php endif; ?>
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="sets">sets</label>
							<input type="number" class="form-control" name="sets" id="sets" required value="<?php echo e(isset($activity) ? $activity->sets : old('sets')); ?>" placeholder="Enter sets">
							<?php if($errors->has('sets')): ?>
								<p class="help text-danger"><?php echo e($errors->first('sets')); ?></p>
							<?php endif; ?>
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="rest_between_sets">rest between sets</label>
							<input type="number" class="form-control" name="rest_between_sets" id="rest_between_sets" required value="<?php echo e(isset($activity) ? $activity->rest_between_sets : old('rest_between_sets')); ?>" placeholder="Enter rest between sets">
							<?php if($errors->has('rest_between_sets')): ?>
								<p class="help text-danger"><?php echo e($errors->first('rest_between_sets')); ?></p>
							<?php endif; ?>
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="rest_between_exercises">rest between exercises</label>
						    <input type="number" class="form-control" name="rest_between_exercises" id="rest_between_exercises" required value="<?php echo e(isset($activity) ? $activity->rest_between_exercises : old('rest_between_exercises')); ?>" placeholder="Enter rest between exercises">
							<?php if($errors->has('rest_between_exercises')): ?>
								<p class="help text-danger"><?php echo e($errors->first('rest_between_exercises')); ?></p>
							<?php endif; ?>
						</div>


						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">Assign</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- assign exercise form END -->
		
		
		<!-- assignd exercises START -->
		<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Asseined Exercises</h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">

						<!-- Start Table -->
						<div class="table-responsive">
							<table class="table text-md-nowrap" id="example1">
								<thead>
									<tr>
										<th class="all border-bottom-0">#</th>
										<th class="all border-bottom-0">exercise</th>
										<th class="all border-bottom-0">reps</th>
										<th class="all border-bottom-0">sets</th>
										<th class="all border-bottom-0">rest between sets</th>
										<th class="all border-bottom-0">rest between exercises</th>
										<th class="all border-bottom-0">date</th>
										<th class="all border-bottom-0">Action</th>
									</tr>
								</thead>
								<tbody>
								    <?php $i=1; ?>
									<?php $__currentLoopData = $assigned_exercises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assigned_exercise): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($i); ?></td>
										<td><?php echo e($assigned_exercise->exercise? $assigned_exercise->exercise->title: ''); ?></td>
										<td><?php echo e($assigned_exercise->reps); ?></td>
										<td><?php echo e($assigned_exercise->sets); ?></td>
										<td><?php echo e($assigned_exercise->rest_between_sets); ?></td>
										<td><?php echo e($assigned_exercise->rest_between_exercises); ?></td>
										<td><?php echo e(date('d M Y', strtotime($assigned_exercise->created_at))); ?></td>
										<td>
											<a href="<?php echo e(route('delete_assigned_exercise', ['id' => $assigned_exercise->id])); ?>" class="deleteRow mx-1" data-id="<?php echo e($assigned_exercise->id); ?>"><i class="fa-solid fa-trash text-danger"></i></a>
										</td>
									</tr>
									<?php $i++; ?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
						<!-- End Table -->


					</div>
				</div>
			</div>
		<!-- assignd exercises END -->
		<?php endif; ?>


	</div>
	<!-- row -->


</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>
<!-- Include the CKEditor library -->
<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>

<!-- Initialize CKEditor -->
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smartcredit/public_html/fitnasyum-ad/resources/views/activities/form.blade.php ENDPATH**/ ?>