
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($coupon) ? 'Edit coupon': 'Add coupon'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">coupon</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($coupon) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- coupon form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-header">
					<h5 class="text-dark">Used <span class="text-danger"><?php echo e($applied_coupons_count); ?></span> time(s)</h5>
				</div>
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($coupon) ? Route('coupons.update', ['coupon'=>$coupon->id]) : Route('coupons.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-6">
							<label class="text-capitalize" for="coupon_code">coupon code</label>
							<input type="text" class="form-control" name="coupon_code" id="coupon_code" required value="<?php echo e(isset($coupon) ? $coupon->coupon_code : old('coupon_code')); ?>" placeholder="Enter coupon code">
							<?php if($errors->has('coupon_code')): ?>
								<p class="help text-danger"><?php echo e($errors->first('coupon_code')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="value">value</label>
							<input type="number" class="form-control" name="value" id="value" required value="<?php echo e(isset($coupon) ? $coupon->value : old('value')); ?>" placeholder="Enter value">
							<?php if($errors->has('value')): ?>
								<p class="help text-danger"><?php echo e($errors->first('value')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="start_date">start date</label>
							<input type="date" class="form-control" name="start_date" id="start_date" required value="<?php echo e(isset($coupon) ? $coupon->start_date : old('start_date')); ?>" placeholder="Enter start date">
							<?php if($errors->has('start_date')): ?>
								<p class="help text-danger"><?php echo e($errors->first('start_date')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="end_date">end date</label>
							<input type="date" class="form-control" name="end_date" id="end_date" required value="<?php echo e(isset($coupon) ? $coupon->end_date : old('end_date')); ?>" placeholder="Enter end date">
							<?php if($errors->has('end_date')): ?>
								<p class="help text-danger"><?php echo e($errors->first('end_date')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="max_usage_num">maximum total usage limit</label>
							<input type="number" class="form-control" name="max_usage_num" id="max_usage_num" required value="<?php echo e(isset($coupon) ? $coupon->max_usage_num : old('max_usage_num')); ?>" placeholder="Enter max usage num">
							<?php if($errors->has('max_usage_num')): ?>
								<p class="help text-danger"><?php echo e($errors->first('max_usage_num')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="minimum_apply_amount">minimum apply amount</label>
							<input type="number" class="form-control" name="minimum_apply_amount" id="minimum_apply_amount" required value="<?php echo e(isset($coupon) ? $coupon->minimum_apply_amount : old('minimum_apply_amount')); ?>" placeholder="Enter minimum apply amount">
							<?php if($errors->has('minimum_apply_amount')): ?>
								<p class="help text-danger"><?php echo e($errors->first('minimum_apply_amount')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12 mt-2 mb-4">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php isset($coupon) ? $active = $coupon->active : $active = 0; ?>
									<input type="checkbox" data-checkboxes="mygroup" name="active" value="1" <?php echo e($active ? 'checked' : ''); ?> class="custom-control-input" id="active">
									<label for="active" class="custom-control-label mt-1"> Is active?</label>
								</div>
							</div>
						</div>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($coupon) ? 'Update': 'Create'); ?></button>
							</div>
						</div>

					</form>
				</div>
			</div>
		</div>
		<!-- coupon form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\masterfit-admin\resources\views/coupons/form.blade.php ENDPATH**/ ?>