
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($course) ? 'Edit course': 'Add course'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">course</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($course) ? 'Edit': 'Create'); ?></span>
			</div>
			<?php if(isset($students)): ?>
			<div class="d-flex">
				<h4 class="content-title mt-3 tx-16">(<?php echo e(count($students)); ?>) <span class="text-primary">Students Registered</span></h4>
			</div>
			<?php endif; ?>
			<?php if(isset($course)): ?>
			<div class="d-flex">
				<a href="<?php echo e(url('/admin/course/'.$course->id.'/lectures')); ?>" target="_blank" class="btn btn-success mt-3" ><i class="fa-solid fa-expand"></i> Show all lectures</a>
			</div>
			<?php endif; ?>

		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- course form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($course) ? Route('courses.update', ['course'=>$course->id]) : Route('courses.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($course) ? $course->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="slug">course slug</label>
							<input type="text" class="form-control" name="slug" id="slug" required value="<?php echo e(isset($course) ? $course->slug : old('slug')); ?>" placeholder="Ex: new-course">
							<?php if($errors->has('slug')): ?>
								<p class="help text-danger"><?php echo e($errors->first('slug')); ?></p>
							<?php endif; ?>
						</div>


						<div class="form-group col-6">
							<label class="text-capitalize" for="original_price">original price</label>
							<input type="number" class="form-control" name="original_price" id="original_price" required value="<?php echo e(isset($course) ? $course->original_price : old('original_price')); ?>" placeholder="Enter original price">
							<?php if($errors->has('original_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('original_price')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="sell_price">sell price</label>
							<input type="number" class="form-control" name="sell_price" id="sell_price" required value="<?php echo e(isset($course) ? $course->sell_price : old('sell_price')); ?>" placeholder="Enter sell price">
							<?php if($errors->has('sell_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('sell_price')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea class="form-control" rows="6" name="description" id="description" placeholder="Enter description" required><?php echo e(isset($course) ? $course->description : old('description')); ?></textarea>
							<?php if($errors->has('description')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="about_course"> about course</label>
							<textarea class="about_course" name="about_course" rows="8"><?php echo e(isset($course) ? $course->about_course : old('about_course')); ?></textarea>
							<?php if($errors->has('about_course')): ?>
								<p class="help text-danger"><?php echo e($errors->first('about_course')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="instructor">instructor</label>
							<input type="text" class="form-control" name="instructor" id="instructor" required value="<?php echo e(isset($course) ? $course->instructor : old('instructor')); ?>" placeholder="Enter instructor">
							<?php if($errors->has('instructor')): ?>
								<p class="help text-danger"><?php echo e($errors->first('instructor')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="difficulty_level">difficulty level</label>
							<input type="text" class="form-control" name="difficulty_level" id="difficulty_level" required value="<?php echo e(isset($course) ? $course->difficulty_level : old('difficulty_level')); ?>" placeholder="Ex: All levels">
							<?php if($errors->has('difficulty_level')): ?>
								<p class="help text-danger"><?php echo e($errors->first('difficulty_level')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="duration">duration</label>
							<input type="text" class="form-control" name="duration" id="duration" required value="<?php echo e(isset($course) ? $course->duration : old('duration')); ?>" placeholder="Enter duration">
							<?php if($errors->has('duration')): ?>
								<p class="help text-danger"><?php echo e($errors->first('duration')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="lectures_count">lectures count</label>
							<input type="number" class="form-control" name="lectures_count" id="lectures_count" required value="<?php echo e(isset($course) ? $course->lectures_count : old('lectures_count')); ?>" placeholder="Enter lectures_count">
							<?php if($errors->has('lectures_count')): ?>
								<p class="help text-danger"><?php echo e($errors->first('lectures_count')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12 mt-2 mb-4">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php isset($course) ? $active = $course->active : $active = 0; ?>
									<input type="checkbox" data-checkboxes="mygroup" name="active" value="1" <?php echo e($active ? 'checked' : ''); ?> class="custom-control-input" id="active">
									<label for="active" class="custom-control-label mt-1"> Is active?</label>
								</div>
							</div>
						</div>

						<!-- Thumbnail Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Thumbnail Upload</h6>
											</div>
											<div class="row mb-4">
												<?php if(isset($course)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src=" <?php echo e(asset('uploads/courses/'.$course->thumbnail)); ?>"
														class="w-100 shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($course->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
												<div class="col-sm-12 col-md-4">
													<input type="file" name="thumbnail" class="dropify" data-height="200" />
												</div>
											</div>
										</div>
										<?php if($errors->has('thumbnail')): ?>
											<p class="help text-danger"><?php echo e($errors->first('thumbnail')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- Thumbnail Upload closed -->

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($course) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- course form END -->

		<?php if(isset($course)): ?>

		<!-- Lecture form start -->
		<div class="col-sm-12">
			<div class="card pt-0 box-shadow-0">
				<div class="card-header">
					<h4>Add New Lecture</h4>
				</div>
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($lecture) ? Route('lectures.update', ['lecture'=>$lecture->id]) : Route('lectures.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="course_id" value="<?php echo e($course->id); ?>">
						<div class="form-group col-8">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($lecture) ? $lecture->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-4">
							<label class="text-capitalize" for="sort_order">Sort order</label>
							<input type="number" class="form-control" name="sort_order" id="sort_order" required value="<?php echo e(isset($lecture) ? $lecture->sort_order : old('sort_order')); ?>" placeholder="Enter sort order">
							<?php if($errors->has('sort_order')): ?>
								<p class="help text-danger"><?php echo e($errors->first('sort_order')); ?></p>
							<?php endif; ?>
						</div>

						<!-- Thumbnail Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Thumbnail Upload</h6>
											</div>
											<div class="row mb-4">
												<?php if(isset($lecture)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src=" <?php echo e(asset('uploads/lectures/'.$lecture->thumbnail)); ?>"
														class="w-100 shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($lecture->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
												<div class="col-sm-12 col-md-4">
													<input type="file" name="thumbnail" class="dropify" data-height="200" />
												</div>
											</div>
										</div>
										<?php if($errors->has('thumbnail')): ?>
											<p class="help text-danger"><?php echo e($errors->first('thumbnail')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- Thumbnail Upload closed -->

						<!-- video Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">
										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Video Upload</h6>
											</div>
											<div class="row mb-4">
												<?php if(isset($lecture) && $lecture->video_src): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<video controls class="w-100 shadow-1-strong rounded mb-4" style="max-height: 210px; min-height: 210px;">
														<source src="<?php echo e(asset('uploads/lectures_videos/' . $lecture->video_src)); ?>" type="video/mp4">
														<!-- You can add additional source elements for different video formats here if needed -->
														Your browser does not support the video tag.
													</video>
												</div>
												<?php endif; ?>
												<div class="col-sm-12 col-md-4">
													<input type="file" name="video_src" accept="video/*" class="dropify" data-height="200" />
												</div>
											</div>
										</div>
										<?php if($errors->has('video_src')): ?>
										<p class="help text-danger"><?php echo e($errors->first('video_src')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- video Upload closed -->


						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($lecture) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- Lecture form END -->

		<?php endif; ?>


	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>
<!--tinymce js-->
<script src="https://cdn.tiny.cloud/1/z11c2h50n7nrfmryazjs4xzib8487mkjns9jlwpqns4wd715/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script>

	// ******** Delete lecture ********

	function deleteRecord(data) {

		var ajaxPromise = ajaxRequest('POST', "<?php echo e(Url('admin/delete/lecture')); ?>", data);

		ajaxPromise.done(function(response) {
			swalAlert(response.message, '' ,response.status);
		});

		ajaxPromise.fail(function(xhr, status, error) {
			swalAlert('Request failed', '' ,0);
			console.log('Request failed:', error);
		});

	}

	function confirmDeleteRecord(deleted_id) {
		return function() {
			deleteRecord(deleted_id);
		};
	}


	$('#fetch-lecs-by-ajax').on('click', '.delete-record' ,function(e) {

		e.preventDefault();

		var data = {
			"_token" : $('input[name="_token"]').val(),
			"record_id" : $(this).data('record-id'),
		};

		swalWithConfirm(confirmDeleteRecord(data));

	});


	// tinymce

	tinymce.init({
        selector: '.about_course',
        height : '400',
		plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
      	toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
		font_size_formats: '8px 10px 12px 14px 16px 17px 18px 20px 22px 24px 28px 32px 36px 40px 48px 56px 64px'
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\digital-dentistry-admin\resources\views/courses/form.blade.php ENDPATH**/ ?>