
<?php $__env->startSection('page-header'); ?>
<!-- breadcrumb -->
<div class="breadcrumb-header justify-content-between">
	<div class="left-content">
		<div>
			<h2 class="main-content-title tx-24 mg-b-1 mg-b-lg-1">Hi, welcome back!</h2>
			<p class="mg-b-0">You can find out the bookings details by scanning the qrcode</p>
		</div>
	</div>
</div>
<!-- /breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row py-4">
	<div class="col-12">
		<div class="card box-shadow-0">
			<form action="<?php echo e(Route('getQrcode')); ?>" method="POST">
				<?php echo csrf_field(); ?>
				<div class="card-header pb-0">
					<h4 class="card-title mb-0">QRCODE</h4>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-12 col-lg-3">
							<input type="text" class="form-control" name="qrcode" required autofocus placeholder="qrcode">
						</div>
						<div class="col-12 col-lg-3 mt-3 mt-lg-0">
							<button class="btn btn-primary">Get INFO</button>
						</div>
					</div>
				</div>
			</form>
		</div>

		<?php if(isset($status)): ?>

		<?php if(isset($booking)): ?>
		<div class="card box-shadow-0 mt-4 p-2">
			<div class="card-header">
				<h4 class="card-title mb-0">Booking Details</h4>
			</div>

			<div class="card-body">

				<table class="table">
					<thead class="bg-primary py-3">
					  <tr>
						<th class="text-white py-3" scope="col">Item</th>
						<th class="text-white py-3" scope="col">Description</th>
					  </tr>
					</thead>
					<tbody>
					  <tr>
						<th scope="row">fullname</th>
						<td><?php echo e($booking->firstname); ?> <?php echo e($booking->lastname); ?></td>
					  </tr>
					  <tr>
						<th scope="row">title</th>
						<td><?php echo e($booking->title); ?></td>
					  </tr>
					  <tr>
						<th scope="row">company</th>
						<td><?php echo e($booking->company); ?></td>
					  </tr>
					  <tr>
						<th scope="row">mobile</th>
						<td><?php echo e($booking->mobile); ?></td>
					  </tr>
					  <tr>
						<th scope="row">email</th>
						<td><?php echo e($booking->email); ?></td>
					  </tr>
					  <tr>
						<th scope="row">address</th>
						<td><?php echo e($booking->address); ?></td>
					  </tr>
					  <tr>
						<th scope="row">region</th>
						<td><?php echo e($booking->region); ?></td>
					  </tr>
					  <tr>
						<th scope="row">governorate</th>
						<td><?php echo e($booking->governorate); ?></td>
					  </tr>
					  <tr>
						<th scope="row">country</th>
						<td><?php echo e($booking->country); ?></td>
					  </tr>
					  <tr>
						<th scope="row">telephone</th>
						<td><?php echo e($booking->telephone); ?></td>
					  </tr>
					  <tr>
						<th scope="row">website</th>
						<td><?php echo e($booking->website); ?></td>
					  </tr>
					  <tr>
						<th scope="row">specialization</th>
						<td><?php echo e($booking->specialization); ?></td>
					  </tr>
					  <tr>
						<th scope="row">source of knowledge</th>
						<td><?php echo e($booking->source_of_knowledge); ?></td>
					  </tr>
					  <?php if(isset($booking->qrcode->time_in)): ?>
					  <tr>
						<th scope="row">Check-in</th>
						<td><?php echo e(date('d M Y - h:i a', strtotime($booking->qrcode->time_in))); ?></td>
					  </tr>
					  <?php endif; ?>
					  <?php if(isset($booking->qrcode->time_out)): ?>
					  <tr>
						<th scope="row">Check-out</th>
						<td><?php echo e(date('d M Y - h:i a', strtotime($booking->qrcode->time_out))); ?></td>
					  </tr>
					  <?php endif; ?>

					  <tr>
						<th scope="row">Action</th>
						<td>
							<a href="<?php echo e(route('print-ticket', ['qrcode'=>$booking->mobile])); ?>"  class="mr-3"><i class="fa fa-print mr-2"></i> Print Badge</a> |
							<a href="<?php echo e(route('print-ticket', ['qrcode'=>$booking->mobile])); ?>" class="ml-3"><i class="fa fa-print mr-2"></i> Print Label</a>
						</td>
					  </tr>
					</tbody>
				</table>

			</div>
		</div>

		<?php else: ?>
		<div class="alert alert-danger">There are no reservations with this qrcode</div>
		<?php endif; ?>

		<?php endif; ?>


	</div>
</div>
	

</div>
<!-- Container closed -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!--Internal  index js -->
<script src="<?php echo e(URL::asset('assets/js/index.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mekaegypt/public_html/smart-solutions/admin/resources/views/index.blade.php ENDPATH**/ ?>