
<?php $__env->startSection('title', 'Pharmacy Categories'); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Data table css -->
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/jquery.dataTables.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/responsive.dataTables.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
				<!-- breadcrumb -->
				<div class="breadcrumb-header justify-content-between">
					<div class="my-auto">
						<div class="d-flex">
							<h4 class="content-title mb-0 my-auto">Dashboard</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ Pharmacy Categories</span>
						</div>
					</div>
				</div>
				<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
				<!-- row opened -->
				<div class="row row-sm">
					<div class="col-xl-12">
						<div class="card">
							<div class="card-header pb-0">
								<div class="d-flex justify-content-between">
									<h4 class="card-title mg-b-0">Pharmacy Categories TABLE</h4>
									<i class="mdi mdi-dots-horizontal text-gray"></i>
								</div>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table text-md-nowrap" id="example1">
										<thead>
											<tr>
												<th class="all border-bottom-0" width="15%">#</th>
												<th class="all border-bottom-0" width="20%">Name</th>
												<th class="all border-bottom-0" width="20%">الإسم</th>
												<th class="all border-bottom-0" width="20%">Parent</th>
												<th class="all border-bottom-0" width="15%">Status</th>
												<th class="all border-bottom-0" width="10%">Action</th>
											</tr>
										</thead>
										<tbody>
											<?php $__currentLoopData = $pharmacy_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pharmacy_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($pharmacy_category->id); ?></td>

												<?php if($pharmacy_category->type == 'img'): ?>
												<td><img src="https://apis.moalj.com<?php echo e($pharmacy_category->name); ?>" height="70" alt="img"></td>
												<td><img src="https://apis.moalj.com<?php echo e($pharmacy_category->name_ar); ?>" height="70" alt="img"></td>
												<?php else: ?>
												<td><?php echo e($pharmacy_category->name); ?></td>
												<td><?php echo e($pharmacy_category->name_ar); ?></td>
												<?php endif; ?>

												<?php if($pharmacy_category->parentCategory && $pharmacy_category->parentCategory->type == 'img'): ?>
												<td><img src="https://apis.moalj.com<?php echo e($pharmacy_category->parentCategory->name); ?>" height="70" alt="img"></td>
												<?php else: ?>

												<?php if($pharmacy_category->parentCategory): ?>
												<td> <?php echo e($pharmacy_category->parentCategory->name); ?></td>
												<?php else: ?>
												<td class="text-primary"> <?php echo e(!$pharmacy_category->parent ? 'Main Category' : ''); ?></td>
												<?php endif; ?>

												<?php endif; ?>

												<td><?php echo e($pharmacy_category->status == 1 ? 'Active' : 'In-Active'); ?></td>
												<td>
													<a href="pharmacy_categories/<?php echo e($pharmacy_category->id); ?>" class="mr-3"><i class="fa-solid fa-pen-to-square"></i></a>
													<a href="#" class="deleteRow" data-id="<?php echo e($pharmacy_category->id); ?>"><i class="fa-solid fa-trash text-danger"></i></a>
												</td>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
					<!--/div-->
				</div>
				<!-- /row -->
			</div>
			<!-- Container closed -->
		</div>
		<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!-- Internal Data tables -->
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/responsive.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.bootstrap4.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jszip.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.colVis.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/responsive.bootstrap4.min.js')); ?>"></script>
<!--Internal  Datatable js -->
<script src="<?php echo e(URL::asset('assets/js/table-data.js')); ?>"></script>

<!--sweetalert2 js -->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
	$(document).ready(function() {
		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			} 
		});

		$('table').on('click', '.deleteRow', function(e) {
			e.preventDefault();

			var deleted_id = $(this).data('id');

			Swal.fire({
				title: 'Do you want to Delete This Record?',
				showCancelButton: true,
				confirmButtonText: 'Delete',
				}).then((result) => {
					if (result.isConfirmed) {
						$.ajax({
							type: "POST",
							url: "<?php echo e(Url('admin/delete/pharmacy_category')); ?>",
							data: {"deleted_id": deleted_id},
							success: function(response) {
								if(response.status == 1) {
									Swal.fire('Deleted !', '' , 'success').then((result) => {
										location.reload();
									});
								} else {
									Swal.fire('Something went wrong !', '' , 'error');
								}
							}
						});
					}
				});
			
		});

	});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/pharmacy_categories/index.blade.php ENDPATH**/ ?>