
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($blog) ? 'Edit blog': 'Add blog'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">blog</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($blog) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- blog form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($blog) ? Route('blogs.update', ['blog'=>$blog->id]) : Route('blogs.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-12">
							<label class="text-capitalize" for="category_id">Category</label>
							<select name="category_id" id="category_id" class="form-control" required>
								<option value="" disabled selected>Choose Category</option>
								<?php $category_id = isset($blog) ? $blog->category_id : ''; ?>
								<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($category->id); ?>" <?php echo e($category_id == $category->id ? 'selected': ''); ?>><?php echo e($category->name); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('category_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('category_id')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($blog) ? $blog->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="overview">overview</label>
							<input type="text" class="form-control" name="overview" id="overview" required value="<?php echo e(isset($blog) ? $blog->overview : old('overview')); ?>" placeholder="Enter overview">
							<?php if($errors->has('overview')): ?>
								<p class="help text-danger"><?php echo e($errors->first('overview')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea name="description" id="editor" rows="10" class="form-control">
								<?php echo e(isset($blog) ? $blog->description : old('description')); ?>

							</textarea>
							<?php if($errors->has('description')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
							<?php endif; ?>
						</div>

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="main_image" accept="image/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($blog)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(config('app.uploads')); ?><?php echo e($blog->main_image); ?>"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($blog->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('main_image')): ?>
											<p class="help text-danger"><?php echo e($errors->first('main_image')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($blog) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- blog form END -->

	</div>
	<!-- row -->

	<!-- Video Upload -->
	<?php if(isset($blog)): ?>
	<!-- row -->
	<div class="row row-sm">
		<!-- Video form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(route("upload/video/blog")); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="record_id" value="<?php echo e($blog->id); ?>">
						<input type="hidden" name="title" value="<?php echo e($blog->title); ?>">
						<input type="hidden" name="description" value="<?php echo e($blog->overview); ?>">
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Video Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="video" accept="video/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($blog->player_embed_url)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<iframe src="<?php echo e($blog->player_embed_url); ?>" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" title="<?php echo e($blog->title); ?>"></iframe>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('video')): ?>
											<p class="help text-danger"><?php echo e($errors->first('video')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">Upload Video</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- Video form END -->
	</div>
	<!-- row -->
	<?php endif; ?>
	<!-- Video Upload -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>
<!-- Include the CKEditor library -->
<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>

<!-- Initialize CKEditor -->
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smartcredit/public_html/fitnasyum-ad/resources/views/blogs/form.blade.php ENDPATH**/ ?>