<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class ActivityToExercise extends Model
{
    use HasFactory;
    
    protected $table = "activity_exercises";

    protected $fillable = [
        'activity_id',
        'exercise_id',
        'reps',
        'sets',
        'rest_between_sets',
        'rest_between_exercises',
    ];

    public function activity() {
        return $this->belongsTo(Activity::class);
    }
    
    public function exercise() {
        return $this->belongsTo(Exercise::class);
    }
    
}
