
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($lab) ? 'Edit Lab': 'Add Lab'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Select2 css -->
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<!--Internal  Datetimepicker-slider css -->
<link href="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/css/amazeui.datetimepicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.css')); ?>" rel="stylesheet">
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<!-- Internal Spectrum-colorpicker css -->
<link href="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Lab</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($lab) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($lab) ? Route('labs.update', ['lab'=>$lab->id]) : Route('labs.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-6">
							<label class="text-capitalize" for="name">lab name</label>
							<input type="text" class="form-control" name="name" id="name" required value="<?php echo e(isset($lab) ? $lab->name : old('name')); ?>" placeholder="Enter lab name">
							<?php if($errors->has('name')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="name">lab arabic name</label>
							<input type="text" class="form-control" name="name_ar" id="name_ar" required value="<?php echo e(isset($lab) ? $lab->name_ar : old('name_ar')); ?>" placeholder="Enter lab arabic name">
							<?php if($errors->has('name_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name_ar')); ?></p>
							<?php endif; ?>
						</div>

						<!--Specialities-->
						<div class="col-12 mt-4">
							<div class="table-responsive">
								<table class="table table-bordered table-addRmeove">
									<thead>
										<tr>
											<th class="text-capitalize font-size-13">Test Name</th>
											<th class="text-capitalize font-size-13">Price</th>
											<th class="text-capitalize font-size-13">action</th>
										</tr>
									</thead>
									<tbody id="tbody_specialities" class="tbody">
										<?php if(isset($lab)): ?> 
										<?php $i=0; ?>
										<?php $__currentLoopData = json_decode($lab->tests); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<?php isset($test->id) ? $test_id = $test->id : $test_id = ''; ?>
										<tr id="R_<?php echo e($i); ?>" data-counter="<?php echo e($i); ?>">
											<td class="row-index" width="50%">
												<div class="form-group">
													<select name="test_id[<?php echo e($i); ?>]" class="form-control" required>
														<option label="Choose one"></option>
														<?php $__currentLoopData = $labTests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $labTest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($labTest->id); ?>" <?php echo e($test_id == $labTest->id ? 'selected' : ''); ?>><?php echo e($labTest->name); ?></option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</td>
											<td class="row-index" width="30%">
												<div class="form-group">
													<input type="number" class="form-control" name="test_price[<?php echo e($i); ?>]" value="<?php echo e($test->price); ?>" placeholder="Enter Price" required>
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php $i++;  ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
										<?php else: ?>
										<tr id="R_0" data-counter="0">
											<td class="row-index" width="50%">
												<div class="form-group">
													<select name="test_id[0]" class="form-control" required>
														<option label="Choose one"></option>
														<?php $__currentLoopData = $labTests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $labTest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($labTest->id); ?>"><?php echo e($labTest->name); ?></option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</td>
											<td class="row-index" width="30%">
												<div class="form-group">
													<input type="number" class="form-control" name="test_price[0]" placeholder="Enter Price" required>
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
						<!--End Specialities-->

						<div class="form-group col-6">
							<label class="text-capitalize" for="rate">rate</label>
							<input type="number" step="0.1" class="form-control" name="rate" id="rate" required value="<?php echo e(isset($lab) ? $lab->rate : old('rate')); ?>" placeholder="Enter rate">
							<?php if($errors->has('rate')): ?>
								<p class="help text-danger"><?php echo e($errors->first('rate')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="phone">phone</label>
							<input type="number" class="form-control" name="phone" id="phone" required value="<?php echo e(isset($lab) ? $lab->phone : old('phone')); ?>" placeholder="Enter phone">
							<?php if($errors->has('phone')): ?>
								<p class="help text-danger"><?php echo e($errors->first('phone')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="governorate_id">governorate</label>
							<?php
								isset($lab) ? $governorate_id = $lab->governorate_id : $governorate_id='';
							?>
							<select class="form-control" name="governorate_id" required>
								<option label="Choose one" <?php echo e(isset($lab) ? '' : 'disabled selected'); ?>></option>
								<?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $governorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($governorate->id); ?>" <?php echo e($governorate->id == $governorate_id ? 'selected' : ''); ?>>
									<?php echo e($governorate->governorate_name_en); ?> - <?php echo e($governorate->governorate_name_ar); ?>

								</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<option label="Choose one" <?php echo e(isset($lab) ? '' : 'disabled selected'); ?>></option>
							</select>
							<?php if($errors->has('governorate_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('governorate_id')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="city_id">City</label>
							<select class="form-control" name="city_id" id="city_id" required>
								<option label="Choose one" class="choose-one-option" <?php echo e(isset($lab) ? '' : 'disabled selected'); ?>></option>
								<?php echo $__env->make('labs.fetch-cities-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</select>
							<?php if($errors->has('city_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('city_id')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="address">address</label>
							<input type="text" class="form-control" name="address" id="address" required value="<?php echo e(isset($lab) ? $lab->address : old('address')); ?>" placeholder="Enter lab address">
							<?php if($errors->has('address')): ?>
								<p class="help text-danger"><?php echo e($errors->first('address')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="address_ar">arabic address</label>
							<input type="text" class="form-control" name="address_ar" id="address_ar" required value="<?php echo e(isset($lab) ? $lab->address_ar : old('address_ar')); ?>" placeholder="Enter arabic address">
							<?php if($errors->has('address_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('address_ar')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="lng">longitude</label>
							<input type="text" class="form-control" name="lng" id="lng" required value="<?php echo e(isset($lab) ? json_decode($lab->location)->lng : old('lng')); ?>" placeholder="Enter Location longitude">
							<?php if($errors->has('lng')): ?>
								<p class="help text-danger"><?php echo e($errors->first('lng')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="lat">latitude</label>
							<input type="text" class="form-control" name="lat" id="lat" required value="<?php echo e(isset($lab) ? json_decode($lab->location)->lat : old('lat')); ?>" placeholder="Enter Location latitude">
							<?php if($errors->has('lat')): ?>
								<p class="help text-danger"><?php echo e($errors->first('lat')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="brief">brief</label>
							<textarea class="form-control" rows="3" name="brief" id="brief" placeholder="Enter lab Brief"><?php echo e(isset($lab) ? $lab->brief : old('brief')); ?></textarea>
							<?php if($errors->has('brief')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="brief">Arabic brief</label>
							<textarea class="form-control" rows="3" name="brief_ar" id="brief_ar" placeholder="Enter arabic brief" required><?php echo e(isset($lab) ? $lab->brief_ar : old('brief_ar')); ?></textarea>
							<?php if($errors->has('brief_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief_ar')); ?></p>
							<?php endif; ?>
						</div>

						<!--Days Off-->
						<div class="col-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Days Off
									</div>
									<?php
										$days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
										$i=0;
									?>
									<div class="row row-sm mg-b-20">
									<?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<div class="form-group d-inline-block">
											<div class="checkbox">
												<div class="custom-checkbox custom-control">
													<?php if(isset($lab)): ?>
													<?php $daysOff = json_decode($lab->daysOff); ?>
													<input type="checkbox" data-checkboxes="mygroup" name="daysOff[<?php echo e($i); ?>]" value="1" data-value="<?php echo e($i); ?>" class="custom-control-input toggle-checkbox" <?php echo e(in_array($i, $daysOff) ? 'checked' : ''); ?> id="daysOff_<?php echo e($i); ?>">
													<?php else: ?>
													<input type="checkbox" data-checkboxes="mygroup" name="daysOff[<?php echo e($i); ?>]" value="1"  data-value="<?php echo e($i); ?>" class="custom-control-input toggle-checkbox" id="daysOff_<?php echo e($i); ?>">
													<?php endif; ?>
													<label for="daysOff_<?php echo e($i); ?>" class="custom-control-label mt-1"> <?php echo e($day); ?></label>
												</div>
											</div>
										</div>
									<?php $i++;?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</div>									

									
								</div>
							</div>
						</div>
						<!--Days Off Closed-->

						<!--available_hours-->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Available hours
									</div>
									<?php
										$days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
										$i=0;
									?>
									<?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php if(isset($lab)): ?>
									<?php $available_hours =  json_decode($lab->available_hours);?>
									<?php endif; ?>
									<div class="row row-sm mg-b-20">
										<div class="input-group wd-125 mr-3">
											<div class="input-group-prepend">
												<div class="input-group-text wd-125">
													<?php echo e($day); ?>

												</div>
											</div>
										</div>
										<div class="input-group col-6 col-md-4">
											<div class="input-group-prepend">
												<div class="input-group-text">
													From
												</div>
											</div><input class="form-control available_input" data-dayCounter="<?php echo e($i); ?>" name="from[<?php echo e($i); ?>]" value="<?php echo e(isset($lab) ?  $available_hours[$i]->from : ''); ?>" type="time" required>
											<!-- </div><input class="form-control available_input" data-dayCounter="<?php echo e($i); ?>" name="from[<?php echo e($i); ?>]" value="10:20" type="time" required> -->
										</div>
										<div class="input-group col-6 col-md-4">
											<div class="input-group-prepend">
												<div class="input-group-text">
													To
												</div>
											</div><input class="form-control available_input" data-dayCounter="<?php echo e($i); ?>" name="to[<?php echo e($i); ?>]" value="<?php echo e(isset($lab) ?  $available_hours[$i]->to : ''); ?>" type="time" required>
											<!-- </div><input class="form-control available_input" data-dayCounter="<?php echo e($i); ?>" name="to[<?php echo e($i); ?>]" value="10:20" type="time" required> -->
										</div>
									</div>									
									<?php $i++;?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									
								</div>
							</div>
						</div>
						<!--available_hours Closed-->

						<!-- Image Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">
										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Image Upload</h6>
											</div>
											<div class="row mb-4">
												<?php if(isset($lab->pic)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e($lab->pic); ?>"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($lab->name); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
												<div class="col-sm-12 col-md-4">
													<input type="file" name="pic" class="dropify" data-height="200" />
												</div>
											</div>
										</div>
										<?php if($errors->has('pic')): ?>
											<p class="help text-danger"><?php echo e($errors->first('pic')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- Image Upload closed -->

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($lab) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal  Datepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<!--Internal dynamicrows js-->
<script src="<?php echo e(URL::asset('assets/js/dynamicrows.js')); ?>"></script>

<!--Internal  jquery.maskedinput js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery.maskedinput/jquery.maskedinput.js')); ?>"></script>
<!--Internal  spectrum-colorpicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.js')); ?>"></script>
<!-- Internal Select2.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
<!--Internal Ion.rangeSlider.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js')); ?>"></script>
<!--Internal  jquery-simple-datetimepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/js/amazeui.datetimepicker.min.js')); ?>"></script>
<!-- Ionicons js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.js')); ?>"></script>
<!--Internal  pickerjs js -->
<script src="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.js')); ?>"></script>
<!-- Internal form-elements js -->
<script src="<?php echo e(URL::asset('assets/js/form-elements.js')); ?>"></script>

<script>
    $(document).ready(function () {

		// ******** Start specialties ********

		// Denotes total number of rows
		var rowIdx;
		// jQuery button click event to add a row
		$('#tbody_specialities').on('click', '.addBtn', function () {

			rowIdx = $(this).parents('tbody').find("tr").last().data('counter');

			// Adding a row inside the tbody.
			$('#tbody_specialities').append(`
			<tr id="R_${++rowIdx}" data-counter="${rowIdx}">
				<td class="row-index" width="50%">
					<div class="form-group">
						<select name="test_id[${rowIdx}]" class="form-control" required>
							<option label="Choose one"></option>
							<?php $__currentLoopData = $labTests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $labTest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($labTest->id); ?>"><?php echo e($labTest->name); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
					</div>
				</td>
				<td class="row-index" width="30%">
					<div class="form-group">
						<input type="number" class="form-control" name="test_price[${rowIdx}]" placeholder="Enter Price" required>
					</div>
				</td>
				<td width="20%">
					<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
					<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
				</td>
			</tr>`);
		});

      	// jQuery button click event to remove a row.
		$('#tbody_specialities').on('click', '.remove', function () {

			// Check If Is There Only One Row
			if($(this).parents('tbody').find("tr").length == 1) {

			} else {

				// Getting all the rows next to the row
				// containing the clicked button
				var child = $(this).closest('tr').nextAll();

				// Iterating across all the rows 
				// obtained to change the index
				child.each(function () {

					// Getting <tr> id.
					var id = $(this).attr('id');

					// Getting the <p> inside the .row-index class.
					var idx = $(this).children('.row-index').children('p');

					// Gets the row number from <tr> id.
					var dig = parseInt(id.substring(1));

					// Modifying row index.
					idx.html(`Row ${dig - 1}`);

					// Modifying row id.
					$(this).attr('id', `R_${dig - 1}`);
				});

				// Removing the current row.
				$(this).closest('tr').remove();

				// Decreasing total number of rows by 1.
				rowIdx--;

			}
		});


		// ******** Fetch citits when choose governate ********
		$('select[name="governorate_id"]').on('change', function() {

		var laodingOption = '<option class="loading-option">Loading cities...</option>';

		// Show Loading Cities Option
		$('#city_id').html('');
		$('#city_id').html(laodingOption);

		var data = {
			"_token" : $('input[name="_token"]').val(),
			"governorate_id" : $(this).val()
		};

		$.ajax({
			type: "POST",
			url: "<?php echo e(route('labs-fetch-cities')); ?>",
			data: data,
			success: function(data) {
				$('#city_id').html('');
				$('#city_id').html(data);
			}
		});
		});

		// ******** removeAttr required from availlabe hours inputs for the day off ********
		let daysCheckedArr = [];
		$('.toggle-checkbox:checked').each(function() {
			daysCheckedArr.push($(this).attr('data-value'));
		});

		$('.available_input').each(function() {
			for (key in daysCheckedArr) {
				if( $(this).attr('data-dayCounter') ==  daysCheckedArr[key]) {
					$(this).removeAttr('required');
					$(this).attr('type', 'text');
				}
			}
		});
		



		// day_off checkbox functions
		$('.toggle-checkbox').on('change', function() {

			// removeAttr required from availlabe hours inputs for the day off
			let daysCheckedArr = [];
			$('.toggle-checkbox:checked').each(function() {
				daysCheckedArr.push($(this).attr('data-value'));
			});

			$('.available_input').attr('required', 'required').attr('type', 'time');
			$('.available_input').each(function() {
				for (key in daysCheckedArr) {
					if( $(this).attr('data-dayCounter') == daysCheckedArr[key]) {
						$(this).removeAttr('required');
						$(this).attr('type', 'text');
					}
				}
				
			});
			
			
		});

		
    });
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/labs/form.blade.php ENDPATH**/ ?>