
<?php $__env->startSection('title', 'Home Visits'); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Data table css -->
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/jquery.dataTables.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/responsive.dataTables.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
				<!-- breadcrumb -->
				<div class="breadcrumb-header justify-content-between">
					<div class="my-auto">
						<div class="d-flex">
							<h4 class="content-title mb-0 my-auto">Dashboard</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ Home Visits</span>
						</div>
					</div>
				</div>
				<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
				<!-- row opened -->
				<div class="row row-sm">
					<div class="col-xl-12">
						<div class="card">
							<div class="card-header pb-0">
								<div class="d-flex justify-content-between">
									<h4 class="card-title mg-b-0">Home Visits TABLE</h4>
									<i class="mdi mdi-dots-horizontal text-gray"></i>
								</div>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table text-md-nowrap" id="example1">
										<thead>
											<tr>
												<th class="all border-bottom-0">#</th>
												<th class="all border-bottom-0">User Name</th>
												<th class="all border-bottom-0">Area</th>
												<th class="all border-bottom-0">Phone</th>
												<th class="all border-bottom-0">Full Name</th>
												<th class="all border-bottom-0">Speciality</th>
												<th class="all border-bottom-0">Creation Date</th>
												<th class="all border-bottom-0">Status</th>
											</tr>
										</thead>
										<tbody>
											<?php $__currentLoopData = $home_visits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $home_visit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php
												if($home_visit->customer) {
													$customer_name = $home_visit->customer->firstname . " " .$home_visit->customer->lastname; 
												} else {
													$customer_name = 'Undefined';
												}
											?>
											<tr>
												<td><?php echo e($home_visit->id); ?></td>
												<td><?php echo e($customer_name); ?></td>
												<td><?php echo e($home_visit->area); ?></td>
												<td><?php echo e($home_visit->phone_number); ?></td>
												<td><?php echo e($home_visit->full_name); ?></td>
												<td><?php echo e($home_visit->spec); ?></td>
												<td><?php echo e(date('d-m-Y', strtotime($home_visit->date_added))); ?></td>
												<td>
													<select name="status" data-id="<?php echo e($home_visit->id); ?>" class="form-control home_visit_id pb-2 pr-0">
														<option value="0" <?php echo e($home_visit->status == 0 ? 'selected' : ''); ?>>Pending</option>
														<option value="1" <?php echo e($home_visit->status == 1 ? 'selected' : ''); ?>>Confirmed</option>
													</select>
												</td>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
					<!--/div-->
				</div>
				<!-- /row -->
			</div>
			<!-- Container closed -->
		</div>
		<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!-- Internal Data tables -->
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/responsive.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.bootstrap4.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jszip.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.colVis.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/responsive.bootstrap4.min.js')); ?>"></script>
<!--Internal  Datatable js -->
<script src="<?php echo e(URL::asset('assets/js/table-data.js')); ?>"></script>

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script type="text/javascript">

	$(document).ready(function() {
		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			}
		});

		$('.home_visit_id').on('change', function(e) {
			e.preventDefault();

			var data = {
				"status_id" : $(this).val(),
				"home_visit_id" : $(this).data('id'),
			};


			swal({
				title: "Are you sure?",
				icon: "warning",
				buttons: true,
				dangerMode: true,
			})
			.then((willDelete) => {
				if (willDelete) {

					$.ajax({
						type: "POST",
						url: "<?php echo e(Url('admin/home_visit/updateStatus')); ?>",
						data:data,
						success: function(response)
						{

							if(response.status == 1) {

								swal('Status Updated Successfully', {
									icon: 'success',
								})
								.then((result) => {
									location.reload();
								});

							} else {

								swal('Something went wrong !', {
									icon: 'error',
								})
								.then((result) => {
									location.reload();
								});


							}

							
						}
					});

				}

			});

		});

	});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/home_visits/index.blade.php ENDPATH**/ ?>