
<?php $__env->startSection('title', 'Doctors'); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Data table css -->
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/jquery.dataTables.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/responsive.dataTables.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
<!-- breadcrumb -->
<div class="breadcrumb-header justify-content-between">
	<div class="my-auto">
		<div class="d-flex">
			<h4 class="content-title mb-0 my-auto">Dashboard</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ Doctors</span>
		</div>
	</div>
</div>
<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
		<!-- row opened -->
		<div class="row row-sm">

			<!-- Filter form start -->
			<div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
				<form action="<?php echo e(route('doctors.filter')); ?>" method="POST">
					<?php echo e(csrf_field()); ?>


					<div class="row bg-white py-4">
						<div class="col-4 col-xl-3">
							<div class="form-group">
								<select name="governorate_id" id="governorate_id" class="form-control">
									<option disabled selected>Governorate</option>
									<?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $governorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($governorate['id']); ?>"><?php echo e($governorate['governorate_name_en']); ?> - <?php echo e($governorate['governorate_name_ar']); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>
						<div class="col-4 col-xl-2">
							<div class="form-group">
								<select name="city_id" id="city_id" class="form-control">
									<option disabled selected>City</option>
									<?php echo $__env->make('doctors.fetch-cities-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
								</select>
							</div>
						</div>
						<div class="col-4 col-xl-2">
							<div class="form-group">
								<select name="specialty_value" id="specialty_value" class="form-control">
									<option disabled selected>Specialty</option>
									<?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($specialty->value); ?>">
										<?php echo e($specialty->specialty); ?> - <?php echo e($specialty->specialty_ar); ?>

									</option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>
						<div class="col-4 col-xl-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary" style="width: 100%; font-size: 14px">Filter</button>
							</div>
						</div>
						<div class="col-4 col-xl-2">
							<div class="form-group">
								<a href="<?php echo e(route('doctors.index')); ?>" class="btn btn-danger" style="width: 100%; font-size: 14px">Reset</a>
							</div>
						</div>

					</div>
			
				</form>
			</div>

			<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Doctors TABLE</h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">
						<div class="table-responsive">

							

							<table class="table text-md-nowrap" id="example1">
								<thead>
									<tr>
										<th class="all border-bottom-0">#</th>
										<th class="all border-bottom-0">Name</th>
										<th class="all border-bottom-0">Specialty</th>
										<th class="all border-bottom-0">Sub Specialty</th>
										<th class="all border-bottom-0">Governorate</th>
										<th class="all border-bottom-0">Cost</th>
										<th class="all border-bottom-0">Type</th>
										<th class="all border-bottom-0">Action</th>
									</tr>
								</thead>
								<tbody>
									<?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($doctor->id); ?></td>
										<td><?php echo e($doctor->name); ?></td>
										<td><?php echo e($doctor->specialty); ?></td>
										<td><?php echo e($doctor->sub_specialties); ?></td>
										<td><?php echo e(isset($doctor->governorate) ? $doctor->governorate->governorate_name_en : 'Undefined'); ?></td>
										<td><?php echo e($doctor->cost); ?></td>
										<td><?php echo e($doctor->type); ?></td>
										<td>
											<a href="doctors/<?php echo e($doctor->id); ?>" class="mr-3"><i class="fa-solid fa-pen-to-square"></i></a>
											<a href="#" class="deleteRow" data-id="<?php echo e($doctor->id); ?>"><i class="fa-solid fa-trash text-danger" title="Delete Doctor"></i></a>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<!--/div-->
		</div>
		<!-- /row -->
	</div>
	<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!-- Internal Data tables -->
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/responsive.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.bootstrap4.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jszip.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.colVis.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/responsive.bootstrap4.min.js')); ?>"></script>
<!--Internal  Datatable js -->
<script src="<?php echo e(URL::asset('assets/js/table-data.js')); ?>"></script>
<!--sweetalert2 js -->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
	$(document).ready(function() {

		// ***** Fetch citits when choose governate
		$('select[name="governorate_id"]').on('change', function() {

			var laodingOption = '<option class="loading-option">Loading cities...</option>';

			// Show Loading Cities Option
			$('#city_id').html('');
			$('#city_id').html(laodingOption);

			var data = {
				"_token" : $('input[name="_token"]').val(),
				"governorate_id" : $(this).val()
			};

			$.ajax({
				type: "POST",
				url: "<?php echo e(route('doctors-fetch-cities')); ?>",
				data: data,
				success: function(data) {
					$('#city_id').html('');
                    $('#city_id').html(data);
				}
			});
		});


		// **** Delete Record
		$('.table').on('click', '.deleteRow', function(e) {
			e.preventDefault();

			var data = {
				"_token" : $('input[name="_token"]').val(),
				"deleted_id" : $(this).data('id')
			};

			Swal.fire({
				title: 'Do you want to Delete This Record?',
				showCancelButton: true,
				confirmButtonText: 'Delete',
			}).then((result) => {
				if (result.isConfirmed) {
					$.ajax({
						type: "POST",
						url: "<?php echo e(Url('admin/delete/doctor')); ?>",
						data: data,
						success: function(response) {
							if(response.status == 1) {
								Swal.fire(response.message, '' , 'success').then((result) => {
									location.reload();
								});
							} else {
								Swal.fire(response.message, '' , 'error');
							}
						}
					});
				}
			});
			
		});

	});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/doctors/index.blade.php ENDPATH**/ ?>