
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($doctor) ? 'Edit Doctor': 'Add Doctor'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Select2 css -->
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<!--Internal  Datetimepicker-slider css -->
<link href="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/css/amazeui.datetimepicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.css')); ?>" rel="stylesheet">
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>
<!-- Internal Spectrum-colorpicker css -->
<link href="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Doctor</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($doctor) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php if(isset($doctor) && $doctor->deleted): ?>
	<div class="alert alert-danger">Deleted Doctor Page.</div>	
	<?php else: ?>
		
	<!-- row -->
	<div class="row row-sm">
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($doctor) ? Route('doctors.update', ['doctor'=>$doctor->id]) : Route('doctors.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-6">
							<label class="text-capitalize" for="name">Doctor name</label>
							<input type="text" class="form-control" name="name" id="name" required value="<?php echo e(isset($doctor) ? $doctor->name : old('name')); ?>" placeholder="Enter Doctor name">
							<?php if($errors->has('name')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="name">Doctor arabic name</label>
							<input type="text" class="form-control" name="name_ar" id="name_ar" required value="<?php echo e(isset($doctor) ? $doctor->name_ar : old('name_ar')); ?>" placeholder="Enter Doctor arabic name">
							<?php if($errors->has('name_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name_ar')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="specialty">specialty</label>
							<?php
								isset($doctor) ? $doctorSpecialty = $doctor->specialty : $doctorSpecialty='';
							?>
							<select class="form-control" name="specialty" required>
								<option label="Choose one"></option>
								<?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($specialty->specialty); ?>" <?php echo e($specialty->specialty == $doctorSpecialty ? 'selected' : ''); ?>>
									<?php echo e($specialty->specialty); ?> - <?php echo e($specialty->specialty_ar); ?>

								</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('specialty')): ?>
								<p class="help text-danger"><?php echo e($errors->first('specialty')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="specialty">sub specialty</label>
							<?php
								isset($doctor) ? $doctor_sub_specialty = $doctor->sub_specialties : $doctor_sub_specialty='';
							?>
							<select class="form-control" name="sub_specialties" required>
								<option label="Choose one"></option>
								<?php $__currentLoopData = $sub_specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($sub_specialty->value); ?>" <?php echo e($sub_specialty->value == $doctor_sub_specialty ? 'selected' : ''); ?>>
									<?php echo e($sub_specialty->sub_specialty); ?> - <?php echo e($sub_specialty->sub_specialty_ar); ?>

								</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('sub_specialties')): ?>
								<p class="help text-danger"><?php echo e($errors->first('sub_specialties')); ?></p>
							<?php endif; ?>
						</div>

						<!--sub specialty-->
						<div class="col-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Sub Specialty
									</div>

									<div class="row">
										<div class="form-group col-6">
											<label class="text-capitalize" for="sub_specialty">Sub Specialty</label>
											<input type="text" class="form-control" name="sub_specialty" id="sub_specialty" required value="<?php echo e(isset($doctor) ? $doctor->sub_specialty : old('sub_specialty')); ?>" placeholder="Enter Sub Specialty">
											<?php if($errors->has('sub_specialty')): ?>
												<p class="help text-danger"><?php echo e($errors->first('sub_specialty')); ?></p>
											<?php endif; ?>
										</div>
										<div class="form-group col-6">
											<label class="text-capitalize" for="sub_specialty_ar">التخصص الفرعي</label>
											<input type="text" class="form-control" name="sub_specialty_ar" id="sub_specialty_ar" required value="<?php echo e(isset($doctor) ? $doctor->sub_specialty_ar : old('sub_specialty_ar')); ?>" placeholder="Enter Sub Specialty Ar">
											<?php if($errors->has('sub_specialty_ar')): ?>
												<p class="help text-danger"><?php echo e($errors->first('sub_specialty_ar')); ?></p>
											<?php endif; ?>
										</div>

										<div class="form-group col-6">
											<label class="text-capitalize" for="sub_specialty_brief">brief</label>
											<textarea class="form-control" rows="3" name="sub_specialty_brief" id="sub_specialty_brief" placeholder="Enter brief" required><?php echo e(isset($doctor) ? $doctor->sub_specialty_brief : old('sub_specialty_brief')); ?></textarea>
											<?php if($errors->has('sub_specialty_brief')): ?>
												<p class="help text-danger"><?php echo e($errors->first('sub_specialty_brief')); ?></p>
											<?php endif; ?>
										</div>
										<div class="form-group col-6">
											<label class="text-capitalize" for="sub_specialty_brief_ar">Arabic brief</label>
											<textarea class="form-control" rows="3" name="sub_specialty_brief_ar" id="sub_specialty_brief_ar" placeholder="Enter arabic brief" required><?php echo e(isset($doctor) ? $doctor->sub_specialty_brief_ar : old('sub_specialty_brief_ar')); ?></textarea>
											<?php if($errors->has('sub_specialty_brief_ar')): ?>
												<p class="help text-danger"><?php echo e($errors->first('sub_specialty_brief_ar')); ?></p>
											<?php endif; ?>
										</div>
									</div>

								</div>	
							</div>
						</div>

						<!--End sub specialty-->

						<div class="form-group col-6">
							<label class="text-capitalize" for="personal_phone">Personal phone</label>
							<input type="number" class="form-control" name="personal_phone" id="personal_phone" required value="<?php echo e(isset($doctor) ? $doctor->personal_phone : old('personal_phone')); ?>" placeholder="Enter personal phone">
							<?php if($errors->has('personal_phone')): ?>
								<p class="help text-danger"><?php echo e($errors->first('personal_phone')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="assistant_phone">Doctor assistant phone</label>
							<input type="number" class="form-control" name="assistant_phone" id="assistant_phone" value="<?php echo e(isset($doctor) ? $doctor->assistant_phone : old('assistant_phone')); ?>" placeholder="Enter assistant phone">
							<?php if($errors->has('assistant_phone')): ?>
								<p class="help text-danger"><?php echo e($errors->first('assistant_phone')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="cost">cost</label>
							<input type="number" class="form-control" name="cost" id="cost" required value="<?php echo e(isset($doctor) ? $doctor->cost : old('cost')); ?>" placeholder="Enter Cost">
							<?php if($errors->has('cost')): ?>
								<p class="help text-danger"><?php echo e($errors->first('cost')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="experience_years">experience years</label>
							<input type="number" class="form-control" name="experience_years" id="experience_years" required value="<?php echo e(isset($doctor) ? $doctor->experience_years : old('experience_years')); ?>" placeholder="Enter experience years">
							<?php if($errors->has('experience_years')): ?>
								<p class="help text-danger"><?php echo e($errors->first('experience_years')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="rate">rate</label>
							<input type="number" step="0.1" class="form-control" name="rate" id="rate" required value="<?php echo e(isset($doctor) ? $doctor->rate : old('rate')); ?>" placeholder="Enter rate">
							<?php if($errors->has('rate')): ?>
								<p class="help text-danger"><?php echo e($errors->first('rate')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="contract_date">Date of contract</label>
							<input type="date" class="form-control" name="contract_date" id="contract_date" required value="<?php echo e(isset($doctor) ? $doctor->contract_date : old('contract_date')); ?>" placeholder="Enter Date of contract">
							<?php if($errors->has('contract_date')): ?>
								<p class="help text-danger"><?php echo e($errors->first('contract_date')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="governorate_id">governorate</label>
							<?php
								isset($doctor) ? $governorate_id = $doctor->governorate_id : $governorate_id='';
							?>
							<select class="form-control" name="governorate_id" required>
								<option label="Choose one" <?php echo e(isset($doctor) ? '' : 'disabled selected'); ?>></option>
								<?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $governorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($governorate->id); ?>" <?php echo e($governorate->id == $governorate_id ? 'selected' : ''); ?>>
									<?php echo e($governorate->governorate_name_en); ?> - <?php echo e($governorate->governorate_name_ar); ?>

								</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<option label="Choose one" <?php echo e(isset($doctor) ? '' : 'disabled selected'); ?>></option>
							</select>
							<?php if($errors->has('governorate_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('governorate_id')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="city_id">City</label>
							<select class="form-control" name="city_id" id="city_id" required>
								<option label="Choose one" class="choose-one-option" <?php echo e(isset($doctor) ? '' : 'disabled selected'); ?>></option>
								<?php echo $__env->make('doctors.fetch-cities-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</select>
							<?php if($errors->has('city_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('city_id')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="address">address</label>
							<input type="text" class="form-control" name="address" id="address" required value="<?php echo e(isset($doctor) ? $doctor->address : old('address')); ?>" placeholder="Enter address">
							<?php if($errors->has('address')): ?>
								<p class="help text-danger"><?php echo e($errors->first('address')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="address_ar">arabic address</label>
							<input type="text" class="form-control" name="address_ar" id="address_ar" required value="<?php echo e(isset($doctor) ? $doctor->address_ar : old('address_ar')); ?>" placeholder="Enter arabic address">
							<?php if($errors->has('address_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('address_ar')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="type">type</label>
							<select class="form-control select2-no-search" name="type" id="type" required>
								<option label="Choose one"></option>
								<?php if(isset($doctor)): ?>
								<option value="appointment" <?php echo e($doctor->type == 'appointment' ? 'selected' : ''); ?>>appointment</option>
								<option value="home-visit" <?php echo e($doctor->type == 'home-visit' ? 'selected' : ''); ?>>home-visit</option>
								<option value="video-call" <?php echo e($doctor->type == 'video-call' ? 'selected' : ''); ?>>video-call</option>
								<?php else: ?>
								<option value="appointment">appointment</option>
								<option value="home-visit">home-visit</option>
								<option value="video-call">video-call</option>
								<?php endif; ?>
								
							</select>
							<?php if($errors->has('type')): ?>
								<p class="help text-danger"><?php echo e($errors->first('type')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="waiting_time">waiting time</label>
							<input type="number" class="form-control" name="waiting_time" id="waiting_time" required value="<?php echo e(isset($doctor) ? $doctor->waiting_time : old('waiting_time')); ?>" placeholder="Enter waiting time">
							<?php if($errors->has('waiting_time')): ?>
								<p class="help text-danger"><?php echo e($errors->first('waiting_time')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="lng">longitude</label>
							<input type="text" class="form-control" name="lng" id="lng" required value="<?php echo e(isset($doctor) ? $doctor->lng : old('lng')); ?>" placeholder="Enter longitude">
							<?php if($errors->has('lng')): ?>
								<p class="help text-danger"><?php echo e($errors->first('lng')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="lat">latitude</label>
							<input type="text" class="form-control" name="lat" id="lat" required value="<?php echo e(isset($doctor) ? $doctor->lat : old('lat')); ?>" placeholder="Enter latitude">
							<?php if($errors->has('lat')): ?>
								<p class="help text-danger"><?php echo e($errors->first('lat')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<?php isset($doctor) ? $doc_gender = $doctor->gender : $doc_gender = ''; ?>
							<label class="text-capitalize" for="gender">Gender</label>
							<select name="gender" id="gender" class="form-control" required>
								<option disabled selected value="">Choose Gender</option>
								<option value="male" <?php echo e($doc_gender == 'male' ? 'selected' : ''); ?>>Male</option>
								<option value="female" <?php echo e($doc_gender == 'female' ? 'selected' : ''); ?>>Female</option>
							</select>
							<?php if($errors->has('gender')): ?>
								<p class="help text-danger"><?php echo e($errors->first('gender')); ?></p>
							<?php endif; ?>
						</div>
						<!--Days Off-->
						<div class="col-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Days Off
									</div>
									<?php
										$days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
										$i=0;
									?>
									<div class="row row-sm mg-b-20">
									<?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<div class="form-group d-inline-block">
											<div class="checkbox">
												<div class="custom-checkbox custom-control">
													<?php if(isset($doctor)): ?>
													<?php 
														if(is_array(json_decode($doctor->day_off))) {
															$daysOff = json_decode($doctor->day_off);
															
														} else {
															$daysOff[] = json_decode($doctor->day_off);
														}
													?>
													<input type="checkbox" data-checkboxes="mygroup" name="day_off[<?php echo e($i); ?>]" value="1" data-value="<?php echo e($i); ?>" class="custom-control-input toggle-checkbox" <?php echo e(in_array($i, $daysOff) ? 'checked' : ''); ?> id="day_off_<?php echo e($i); ?>">
													<?php else: ?>
													<input type="checkbox" data-checkboxes="mygroup" name="day_off[<?php echo e($i); ?>]" value="1" data-value="<?php echo e($i); ?>" class="custom-control-input toggle-checkbox" id="day_off_<?php echo e($i); ?>">
													<?php endif; ?>
													<label for="day_off_<?php echo e($i); ?>" class="custom-control-label mt-1"> <?php echo e($day); ?></label>
												</div>
											</div>
										</div>
									<?php $i++;?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</div>									
								</div>
							</div>
						</div>
						<!--Days Off Closed-->

						<div class="form-group col-6">
							<label class="text-capitalize" for="brief">brief</label>
							<textarea class="form-control" rows="3" name="brief" id="brief" placeholder="Enter brief" required><?php echo e(isset($doctor) ? $doctor->brief : old('brief')); ?></textarea>
							<?php if($errors->has('brief')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="brief_ar">Arabic brief</label>
							<textarea class="form-control" rows="3" name="brief_ar" id="brief_ar" placeholder="Enter arabic brief" required><?php echo e(isset($doctor) ? $doctor->brief_ar : old('brief_ar')); ?></textarea>
							<?php if($errors->has('brief_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief_ar')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php if(isset($doctor)): ?>
									<input type="checkbox" name="on_site_checkbox" value="1" <?php echo e($doctor->on_site_hours ? 'checked' : ''); ?> class="custom-control-input availlable-checkbox" id="on_site_checkbox" data-hours-id="on_site_hours">
									<?php else: ?>
									<input type="checkbox" name="on_site_checkbox" value="1" class="custom-control-input availlable-checkbox" id="on_site_checkbox" data-hours-id="on_site_hours">
									<?php endif; ?>
									<label for="on_site_checkbox" class="custom-control-label mt-1"> On Site Availlable Hours?</label>
								</div>
							</div>
						</div>
						
						<div class="col-12 fetch-on_site_hours"></div>

						<div class="form-group col-12">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php if(isset($doctor)): ?>
									<input type="checkbox" name="video_conferenc_checkbox" value="1" <?php echo e($doctor->video_conf_hours ? 'checked' : ''); ?> class="custom-control-input availlable-checkbox" id="video_conferenc_checkbox" data-hours-id="video_conference_hours">
									<?php else: ?>
									<input type="checkbox" name="video_conferenc_checkbox" value="1" class="custom-control-input availlable-checkbox" id="video_conferenc_checkbox" data-hours-id="video_conference_hours">
									<?php endif; ?>
									<label for="video_conferenc_checkbox" class="custom-control-label mt-1"> Video Conference Availlable Hours?</label>
								</div>
							</div>
						</div>

						<div class="col-12 fetch-video_conference_hours"></div>

						<div class="form-group col-12">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php if(isset($doctor)): ?>
									<input type="checkbox" data-checkboxes="mygroup" name="premium" value="true" <?php echo e($doctor->premium == 'true' ? 'checked' : ''); ?> class="custom-control-input" id="premium">
									<?php else: ?>
									<input type="checkbox" data-checkboxes="mygroup" name="premium" value="true" class="custom-control-input" id="premium">
									<?php endif; ?>
									<label for="premium" class="custom-control-label mt-1"> Premium ?</label>
								</div>
							</div>
						</div>

						<div class="form-group col-12">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php if(isset($doctor)): ?>
									<input type="checkbox" data-checkboxes="mygroup" name="clinic_status" value="1" <?php echo e($doctor->clinic_status ? 'checked' : ''); ?> class="custom-control-input" id="clinic_status">
									<?php else: ?>
									<input type="checkbox" data-checkboxes="mygroup" name="clinic_status" value="1" class="custom-control-input" id="clinic_status">
									<?php endif; ?>
									<label for="clinic_status" class="custom-control-label mt-1"> Is the doctor affiliated with one of the clinics or not?</label>
								</div>
							</div>
						</div>

						<div class="form-group col-6 hidden clinics_box">
							<label class="text-capitalize" for="clinic_id">Clinic</label>
							<?php
								isset($doctor) ? $clinic_id = $doctor->clinic_id : $clinic_id='';
							?>
							<select class="form-control" name="clinic_id">
								<option label="Choose one"></option>
								<?php $__currentLoopData = $clinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($clinic->id); ?>" <?php echo e($clinic->id == $clinic_id ? 'selected' : ''); ?>>
									<?php echo e($clinic->name); ?>

								</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('clinic_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('clinic_id')); ?></p>
							<?php endif; ?>
						</div>

						<!-- Image Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">
										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Doctor Profile Image</h6>
											</div>
											<div class="row mb-4">
												<?php if(isset($doctor->pic)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(asset('/uploads/doctors/'.$doctor->pic)); ?>"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($doctor->name); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
												<div class="col-sm-12 col-md-4">
													<input type="file" name="pic" class="dropify" data-height="200"/>
												</div>
											</div>
										</div>
										<?php if($errors->has('pic')): ?>
											<p class="help text-danger"><?php echo e($errors->first('pic')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>

							<div class="row">
								<?php if(isset($doctor->clinic->imgs) ): ?>

								<div class="col-12">
									<h6 class="card-title my-3">Clinic Images</h6>
								</div>
								
								<?php $images = explode(', ', $doctor->clinic->imgs); ?>
		
								<?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php if($image == null): ?>
									<?php continue; ?>
								<?php endif; ?>
								<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
									<img
										src="<?php echo e(asset('/uploads/clinics/'.$image)); ?>"
										class="w-100 shadow-1-strong rounded mb-4 img-fluid"
										alt="<?php echo e($doctor->clinic->title); ?>"
										style="max-height: 280px; min-height: 280px;"
									/>
								</div>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								
								<?php endif; ?>
							</div>
						</div>
						<!-- Image Upload closed -->

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($doctor) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<!-- row -->

	<?php endif; ?>

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal  Datepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>
<!--Internal  jquery.maskedinput js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery.maskedinput/jquery.maskedinput.js')); ?>"></script>
<!--Internal  spectrum-colorpicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.js')); ?>"></script>
<!-- Internal Select2.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
<!--Internal Ion.rangeSlider.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js')); ?>"></script>
<!--Internal  jquery-simple-datetimepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/js/amazeui.datetimepicker.min.js')); ?>"></script>
<!-- Ionicons js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.js')); ?>"></script>
<!--Internal  pickerjs js -->
<script src="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.js')); ?>"></script>
<!-- Internal form-elements js -->
<script src="<?php echo e(URL::asset('assets/js/form-elements.js')); ?>"></script>

<script>
	$(document).ready(function() {

		// day_off checkbox functions
		$('.toggle-checkbox').on('change', function() {

			// removeAttr required from availlabe hours inputs for the day off
			let daysCheckedArr = [];
			$('.toggle-checkbox:checked').each(function() {
				daysCheckedArr.push($(this).attr('data-value'));
			});

			$('.available_input').attr('required', 'required').attr('type', 'time');
			$('.available_input').each(function() {
				for (key in daysCheckedArr) {
					if( $(this).attr('data-dayCounter') == daysCheckedArr[key]) {
						$(this).removeAttr('required');
						$(this).attr('type', 'text');
					}
				}
			});
			
			
		});

		if($('#clinic_status').prop('checked') == true) {
			$('.clinics_box').fadeIn();
			$('select[name="clinic_id"]').attr('required', true);
		}

		// Toggle Display clinics menu
		$('#clinic_status').on('change', function() {
			if($(this).prop('checked') == true) {
				$('.clinics_box').fadeIn();
				$('select[name="clinic_id"]').attr('required', true);
			} else {
				$('.clinics_box').fadeOut();
				$('select[name="clinic_id"]').attr('required', false);
			}
		});

		// Fetch citits when choose governate
		$('select[name="governorate_id"]').on('change', function() {

			var laodingOption = '<option class="loading-option">Loading cities...</option>';

			// Show Loading Cities Option
			$('#city_id').html('');
			$('#city_id').html(laodingOption);

			var data = {
				"_token" : $('input[name="_token"]').val(),
				"governorate_id" : $(this).val()
			};

			$.ajax({
				type: "POST",
				url: "<?php echo e(route('doctors-fetch-cities')); ?>",
				data: data,
				success: function(data) {
					$('#city_id').html('');
                    $('#city_id').html(data);
				}
			});
		});



		// Toggle display availlable hours on click
		var fetchArray = {
			"on_site_hours" : `<div><?php echo $__env->make('doctors.fetch-on_site_hours', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>`,
			"video_conference_hours" : `<div><?php echo $__env->make('doctors.fetch-video_conference_hours', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>`
		};

		$(".availlable-checkbox").click(function() {
			var hours_id = $(this).attr('data-hours-id');
			if( $(this).prop('checked') == true ) {
				$(".fetch-"+hours_id).html(fetchArray[hours_id]);

				$('.available_input').each(function() {

					let daysCheckedArr = [];
					$('.toggle-checkbox:checked').each(function() {
						daysCheckedArr.push($(this).attr('data-value'));
					});
					
					for (key in daysCheckedArr) {
						if( $(this).attr('data-dayCounter') ==  daysCheckedArr[key]) {
							$(this).removeAttr('required');
							$(this).attr('type', 'text');
						}
					}
				});

			} else {
				$(".fetch-"+hours_id).html('');
			}
		});

		// display availlable hours on loading page if cheked true

		$('.availlable-checkbox').each(function() {

			var hours_id = $(this).attr('data-hours-id');

			if( $(this).prop('checked') == true ) {
				$(".fetch-"+hours_id).html(fetchArray[hours_id]);
				
			}
		});

		// removeAttr required from availlabe hours inputs for the day off
		let daysCheckedArr = [];
		$('.toggle-checkbox:checked').each(function() {
			daysCheckedArr.push($(this).attr('data-value'));
		});

		$('.available_input').each(function() {
			for (key in daysCheckedArr) {
				if( $(this).attr('data-dayCounter') ==  daysCheckedArr[key]) {
					$(this).removeAttr('required');
					$(this).attr('type', 'text');
				}
			}
			
		});




	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\smart_solutions_admin\resources\views/doctors/form.blade.php ENDPATH**/ ?>