<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(URL::asset('assets/img/brand/favicon.png')); ?>" type="image/x-icon"/>
    <!--- Style css -->
    <link href="<?php echo e(URL::asset('assets/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(URL::asset('assets/css/print.css')); ?>" rel="stylesheet" type="text/css" media="print">
    <title>Ticket</title>
</head>
<body class="bg-white">


    <div class="d-flex align-items-center justify-content-center pt-5">
        <?php if(isset($booking->qrcode) && isset($_GET['print']) ): ?>

            <?php if($_GET['print'] == 'badge'): ?>

            <div class="content text-center">
                <p class="font-weight-bold"><?php echo e($booking->contact_person); ?></p>
                <p class="font-weight-bold"><?php echo e($booking->title); ?></p>
                <p class="font-weight-bold"><?php echo e($booking->company); ?></p>
                <div class="qrcode-img">
                    <img src="<?php echo e(url('/uploads/qrcodes'). '/' .$booking->qrcode->qrcode_img); ?>" width="150" alt="qrcode">
                </div>
			</div>
            <?php else: ?>

            <div class="content print-only">
                <p class="font-weight-bold my-1"><?php echo e($booking->contact_person); ?></p>
                <p class="font-weight-bold my-1"><?php echo e($booking->title); ?></p>
                <p class="font-weight-bold my-1"><?php echo e($booking->company); ?></p>
                <div class="qrcode-img">
                    <img src="<?php echo e(url('/uploads/qrcodes'). '/' .$booking->qrcode->qrcode_img); ?>" width="150"  alt="qrcode">
                </div>
			</div>

            <?php endif; ?>

		<?php else: ?>
		<div class="alert alert-danger mt-4">There are no reservations with this qrcode</div>
		<?php endif; ?>
    </div>

</body>
</html><?php /**PATH E:\xampp\htdocs\hvac_admin\resources\views/pdf/index.blade.php ENDPATH**/ ?>