
<?php $__env->startSection('title', 'Bookings'); ?>

<?php $__env->startSection('page-header'); ?>
				<!-- breadcrumb -->
				<div class="breadcrumb-header justify-content-between">
					<div class="my-auto">
						<div class="d-flex">
							<h4 class="content-title mb-0 my-auto">Dashboard</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ Bookings</span>
						</div>
					</div>
				</div>
				<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
		<!-- row opened -->
		<div class="row row-sm">
			<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Bookings TABLE</h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">

						<!-- Start Filter -->
						<div class="filter-box">
							<form action="<?php echo e(route('bookings.index', ['page'=>1])); ?>" method="GET">
		
								<input type="hidden" name="page" value="1">
								<input type="hidden" name="filter" value="1">
					
								<div class="row bg-white py-4">
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control" name="firstname" placeholder="FirstName">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control" name="lastname" placeholder="LastName">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="number" class="form-control" name="mobile" placeholder="Mobile">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control" name="company" placeholder="Company">
										</div>
									</div>
									<div class="col-6 col-lg-4">
										<div class="form-group">
											<input type="text" class="form-control date" name="created_at" placeholder="Booking Date">
										</div>
									</div>
		
									<div class="col-6 col-lg-2">
										<div class="form-group">
											<button type="submit" class="btn btn-primary" style="width: 100%"><i class="fa-solid fa-magnifying-glass"></i> Filter</button>
										</div>
									</div>

									<div class="col-6 col-lg-2">
										<div class="form-group">
											<a href="<?php echo e(route('bookings_export', ['records_ids' => json_encode($records_ids)])); ?>" class="btn btn-danger" style="width: 100%"><i class="fa-solid fa-download"></i> Export</a>
										</div>
									</div>
									
								</div>
						
							</form>
						</div>
						<!-- End Filter -->

						<!-- Start Table -->
						<div class="table-responsive">
							<table class="table text-md-nowrap" id="example1">
								<thead>
									<tr>
										<th class="all border-bottom-0">#</th>
										<th class="all border-bottom-0">fullname</th>
										<th class="all border-bottom-0">title</th>
										<th class="all border-bottom-0">company</th>
										<th class="all border-bottom-0">mobile</th>
										<th class="all border-bottom-0">governorate</th>
										<th class="all border-bottom-0">date</th>
										<th class="all border-bottom-0">Action</th>
									</tr>
								</thead>
								<tbody>
									<?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($booking->id); ?></td>
										<td><?php echo e($booking->firstname); ?> <?php echo e($booking->lastname); ?></td>
										<td><?php echo e($booking->title); ?></td>
										<td><?php echo e($booking->company); ?></td>
										<td><?php echo e($booking->mobile); ?></td>
										<td><?php echo e($booking->governorate); ?></td>
										<td><?php echo e(date('d M Y', strtotime($booking->created_at))); ?></td>
										<td>
											<a href="bookings/<?php echo e($booking->id); ?>" class="mr-3"><i class="fa-solid fa-pen-to-square"></i></a>
											<a href="#" class="deleteRow" data-id="<?php echo e($booking->id); ?>"><i class="fa-solid fa-trash text-danger"></i></a>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div>
						<!-- End Table -->



						<!-- Start Pagination -->
						<?php if(count($bookings) > 0): ?>
		
						<div class="text-center text-md-left font-size-14 mb-3 text-lh-1">Showing <?php echo e($page); ?>–<?php echo e($num_of_pages); ?></div>
						<nav aria-label="Page navigation" id="pagiantionNav">
							<ul class="list-pagination-1 pagination border border-color-4 rounded-sm mb-5 mb-lg-0 overflow-auto overflow-xl-visible justify-content-md-center align-items-center py-2">
								
								<li class="page-item <?php echo e($page==1 ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="1" aria-label="Previous" title="Start">
										<i class="fa-solid fa-angles-left"></i>
									</a>
								</li>
								<li class="page-item <?php echo e($page==1 ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($page-1); ?>" aria-label="Previous">
										<i class="fa-solid fa-angle-left" title="Previous"></i>
									</a>
								</li>
		
								<?php
									if($page < 11) {
										$pagination_start = 1;
									} else {
										$pagination_start = ((int) ($page / 10)) * 10;
									}
								?>
		
								<?php for($page_count = $pagination_start, $i=1; $page_count <= $num_of_pages; $page_count++, $i++): ?>
		
								<?php if ($i>10) { break;} ?>
		
								<li class="page-item <?php echo e($page==$page_count ? 'active disabled-link' : ''); ?>">
									<a class="page-link font-size-14 text-dark <?php echo e($page==$page_count ? 'text-white' : ''); ?>" href="#" data-page="<?php echo e($page_count); ?>"><?php echo e($page_count); ?></a>
								</li>
								
								<?php endfor; ?>
		
								<li class="page-item <?php echo e($page==$num_of_pages ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($page+1); ?>" aria-label="Next">
										<i class="fa-solid fa-angle-right" title="Next"></i>
									</a>
								</li>
								<li class="page-item <?php echo e($page==$num_of_pages ? 'disabled' : ''); ?>">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="<?php echo e($num_of_pages); ?>" aria-label="Next" title="End">
										<i class="fa-solid fa-angles-right"></i>
									</a>
								</li>
								
							</ul>
						</nav>
		
						<?php endif; ?>
						<!-- End Pagination -->


					</div>
				</div>
			</div>
			<!--/div-->
		</div>
		<!-- /row -->
	</div>
	<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>

<!--sweetalert2 js -->
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
	$(document).ready(function() {
		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			} 
		});

		$("input.date").focus(function() {
			$(this).attr("type", "date");
		});

		// Delete
		$('.deleteRow').on('click', function(e) {
			e.preventDefault();

			var deleted_id = $(this).data('id');

			Swal.fire({
				title: 'Do you want to Delete This Record?',
				showCancelButton: true,
				confirmButtonText: 'Delete',
				}).then((result) => {
					if (result.isConfirmed) {
						$.ajax({
							type: "POST",
							url: "<?php echo e(Url('admin/delete/booking')); ?>",
							data: {"deleted_id": deleted_id},
							success: function(response) {
								if(response.status == 1) {
									Swal.fire('Deleted !', '' , 'success').then((result) => {
										location.reload();
									});
								} else {
									Swal.fire('Something went wrong !', '' , 'error');
								}
							}
						});
					}
				});
			
		});

		// *** Pagination
		$('#pagiantionNav .page-link').on('click', function(e) {
			e.preventDefault();

			var page = $(this).data('page');

			var params = new URLSearchParams(location.search);
			params.set('page', page);
			window.location.search = params.toString();
			
		});

	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mekaegypt/public_html/smart-solutions/admin/resources/views/bookings/index.blade.php ENDPATH**/ ?>