<!DOCTYPE html>
<html>
<head>
    <?php
        if( isset($_GET['print']) ) {
            $print_type = $_GET['print'];
        } else {
            $print_type = '';
        }
    ?>
  <!-- Favicon -->
  <link rel="icon" href="<?php echo e(URL::asset('assets/img/brand/favicon.png')); ?>" type="image/x-icon"/>
  <!-- Font -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Times+New+Roman">
  <!--- Style css -->
  <?php if($print_type == 'badge'): ?>
  <link href="<?php echo e(URL::asset('assets/css/print-badge.css')); ?>" media="print" rel="stylesheet">
  <?php elseif($print_type == 'label'): ?>
  <link href="<?php echo e(URL::asset('assets/css/print-label.css')); ?>" media="print" rel="stylesheet">
  <?php else: ?>
  <link href="<?php echo e(URL::asset('assets/css/print-label.css')); ?>" media="print" rel="stylesheet">
  <?php endif; ?>
  <title>Ticket</title>
</head>
<body>

    <?php if(isset($bookings)): ?>

    <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <div class="print-only">

            <?php if(isset($booking->qrcode)): ?>

            <?php $print_options = session()->get('printOptions') ?>

            <?php if(is_array($print_options) && count($print_options) > 0): ?>

            <div class="badge-box">
                <?php $__currentLoopData = $print_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $print_option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <p class="label-text"><?php echo e(isset($booking->$print_option) ? $booking->$print_option : ''); ?></p>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <img class="label-img" src="<?php echo e(url('/uploads/qrcodes'). '/' .$booking->qrcode->qrcode_img); ?>"  alt="qrcode">
            </div>

            <?php else: ?>

            <div class="badge-box">
                <p class="label-text"><?php echo e($booking->contact_person); ?></p>
                <p class="label-text"><?php echo e($booking->company); ?></p>
                <img class="label-img" src="<?php echo e(url('/uploads/qrcodes'). '/' .$booking->qrcode->qrcode_img); ?>"  alt="qrcode">
            </div>

            <?php endif; ?>

            

            <?php else: ?>
                <div class="alert alert-danger mt-4">There are no reservations with this qrcode</div>
            <?php endif; ?>

        </div>
        
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
    <?php endif; ?>
    

</body>
</html><?php /**PATH E:\xampp\htdocs\hvac_admin\resources\views/print/print-page.blade.php ENDPATH**/ ?>