@extends('layouts.master')
@section('title')
Customer Details
@endsection
@section('css')
<!---Internal Fileupload css-->
<link href="{{URL::asset('assets/plugins/fileuploads/css/fileupload.css')}}" rel="stylesheet" type="text/css"/>

@endsection
@section('content')
	<!-- row -->
	<div class="row row-sm mt-3">

		<!-- customer start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body">

					<table class="table">
						<thead class="bg-primary py-3">
						  <tr>
							<th class="text-white py-3" scope="col">#Details</th>
							<th class="text-white py-3" scope="col">#{{$customer->id_customer}}</th>
						  </tr>
						</thead>
						<tbody>
						  <tr>
							<th scope="row">fullname</th>
							<td>{{$customer->fullname}}</td>
						  </tr>
						  <tr>
							<th scope="row">phone</th>
							<td>{{$customer->phoneNumber}}</td>
						  </tr>
						  <tr>
							<th scope="row">email</th>
							<td>{{$customer->email}}</td>
						  </tr>
						  <tr>
							<th scope="row">status</th>
							<td>
								<select class="form-control" name="active" id="active" data-customer-id="{{$customer->id_customer}}">
									<option value="1" {{$customer->active == 1 ? 'selected' : ''}} >Active</option>
									<option value="0" {{$customer->active == 0 ? 'selected' : ''}} >Inactive</option>
								</select>
							</td>
						  </tr>
						  <tr>
							<th scope="row">date</th>
							<td>{{date('d M Y', strtotime($customer->date_add))}}</td>
						  </tr>
						  
						</tbody>
					</table>
	
				</div>
			</div>
		</div>
		<!-- customer END -->

		<!-- Health data start -->
		@if (isset($customer->health_info))
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body">

					<table class="table">
						<thead class="bg-primary py-3">
							<tr>
								<th class="text-white py-3" scope="col" style="width: 30%;">#Customer Health Info</th>
								<th class="text-white py-3" scope="col">#{{$customer->health_info->id}}</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<th scope="row" style="width: 30%;">gender</th>
								<td>{{$customer->health_info->gender}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">birth date</th>
								<td>{{$customer->health_info->birth_date}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">weight</th>
								<td>{{$customer->health_info->weight}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">height</th>
								<td>{{$customer->health_info->height}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">fat level</th>
								<td>
									@switch($customer->health_info->fat_level)
										@case(1)
											UNDERWEIGHT
											@break
										@case(2)
											NORMAL
											@break
										@case(3)
											OVERWEIGHT
											@break
										@case(4)
											OBESE
											@break
										@case(5)
											EXTREMELY_OBESE
											@break
										@default
											Undefined
									@endswitch
								</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">fitness level</th>
								<td>{{$customer->health_info->fitness_level}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">is diseased ?</th>
								<td>{{$customer->health_info->is_diseased}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">disease type</th>
								<td>{{$customer->health_info->disease_type}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">is smoke ?</th>
								<td>{{$customer->health_info->is_smoke}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">goal</th>
								<td>{{$customer->health_info->goal}}</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">account type</th>
								<td>{{$customer->health_info->account_type}}</td>
							</tr>
						</tbody>
					</table>
					
	
				</div>
			</div>
		</div>	
		@endif
		
		<!-- Health data END -->


	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
@endsection

@section('js')
<script>

	function updateCustomerStatus(data) {

		var ajaxPromise = ajaxRequest('POST', "{{url('admin/updatecustomerstatus')}}", data);

		ajaxPromise.done(function(response) {
			swalAlert(response.message, '' ,response.status);
		});

		ajaxPromise.fail(function(xhr, status, error) {
			swalAlert('Request failed', '' ,0);
			console.log('Request failed:', error);
		});

	}

	$('document').ready(function() {
		$('select[name="active"]').on("change", function() {
			
			let data = {
				"customer_id" : $(this).data('customer-id'),
				"active" : $(this).val(),
			};

			updateCustomerStatus(data);
		});
	});
</script>
@endsection
