<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\ExerciseController;
use App\Http\Controllers\ActivityController;
use App\Http\Controllers\TypeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth/login');
});

Auth::routes(['register' => false]);

Route::group(['prefix'=>'admin', 'middleware'=>['auth']], function() {

    Route::get('/', [AdminController::class, 'dashboard'])->name('home');

    // customers routes
    Route::resource('/customers', CustomerController::class);
    Route::post('customers/{id}', [CustomerController::class, 'update']);
    Route::post('/delete/customer', [CustomerController::class, 'destroy']);
    Route::post('updatecustomerstatus', [CustomerController::class, 'updateCustomerStatus']);
    
    // categories routes
    Route::resource('/categories', CategoryController::class);
    Route::post('categories/{id}', [CategoryController::class, 'update']);
    Route::post('/delete/category', [CategoryController::class, 'destroy']);

    // blogs routes
    Route::resource('/blogs', BlogController::class);
    Route::post('blogs/{id}', [BlogController::class, 'update']);
    Route::post('/delete/blog', [BlogController::class, 'destroy']);
    Route::post('/upload/video/blog', [BlogController::class, 'uploadVimeoVideo'])->name('upload/video/blog');

    // activities routes
    Route::resource('/activities', ActivityController::class);
    Route::post('activities/{id}', [ActivityController::class, 'update']);
    Route::post('/delete/activity', [ActivityController::class, 'destroy']);
    Route::post('/upload/video/activity', [ActivityController::class, 'uploadVimeoVideo'])->name('upload/video/activity');
    Route::post('/assign_activity_exercise', [ActivityController::class, 'assign_activity_exercise'])->name('assign_activity_exercise');
    Route::get('/delete_assigned_exercise', [ActivityController::class, 'delete_assigned_exercise'])->name('delete_assigned_exercise');
    
    // types routes
    Route::resource('/types', TypeController::class);
    Route::post('types/{id}', [TypeController::class, 'update']);
    Route::post('/delete/type', [TypeController::class, 'destroy']);
    
    // exercises routes
    Route::resource('/exercises', ExerciseController::class);
    Route::post('exercises/{id}', [ExerciseController::class, 'update']);
    Route::post('/delete/exercise', [ExerciseController::class, 'destroy']);
    Route::post('/upload/video/exercise', [ExerciseController::class, 'uploadVimeoVideo'])->name('upload/video/exercise');


});
