<?php

use App\Http\Controllers\Apis\BookingApiController;
use App\Http\Controllers\Apis\LoginController;
use App\Http\Controllers\Apis\QrcodeApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('qrcode_check', [QrcodeApiController::class, 'qrcode_check']);
Route::post('qrcode_process', [QrcodeApiController::class, 'qrcode_process']);
Route::post('booking/create', [BookingApiController::class, 'booking']);
Route::post('login', [LoginController::class, 'login']);
Route::post('getuser', [LoginController::class, 'getUser']);
