@extends('layouts.master')
@section('title')
	{{isset($category) ? 'Edit category': 'Add category'}}
@endsection
@section('css')
<!---Internal Fileupload css-->
<link href="{{URL::asset('assets/plugins/fileuploads/css/fileupload.css')}}" rel="stylesheet" type="text/css"/>

@endsection
@section('page-header')
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">category</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ {{isset($category) ? 'Edit': 'Create'}}</span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
@endsection
@section('content')
	<!-- row -->
	<div class="row row-sm">

		<!-- category form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="{{isset($category) ? Route('categories.update', ['category'=>$category->id]) : Route('categories.store')}}" enctype="multipart/form-data">
						@csrf
						<div class="form-group col-12">
							<label class="text-capitalize" for="name">name</label>
							<input type="text" class="form-control" name="name" id="name" required value="{{isset($category) ? $category->name : old('name')}}" placeholder="Enter name">
							@if ($errors->has('name'))
								<p class="help text-danger">{{$errors->first('name')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="parent_id">parent (إختياري)</label>
							<select name="parent_id" id="parent_id" class="form-control">
								<option value="" disabled selected>Choose Parent Category</option>
								<?php $parent_id = isset($category) ? $category->parent_id : ''; ?>
								@foreach ($categories as $p_category)
									<option value="{{$p_category->id}}" {{$parent_id == $p_category->id ? 'selected': ''}}>{{$p_category->name}}</option>
								@endforeach
							</select>
							@if ($errors->has('parent_id'))
								<p class="help text-danger">{{$errors->first('parent_id')}}</p>
							@endif
						</div>

						<!-- image Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="image" accept="image/*" class="dropify" data-height="200" />
												</div>
												@if (isset($category))
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="{{config('app.uploads')}}{{$category->image}}"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="{{$category->title}}"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												@endif
											</div>
										</div>
										@if ($errors->has('image'))
											<p class="help text-danger">{{$errors->first('image')}}</p>
										@endif
									</div>
								</div>
							</div>
						</div>
						<!-- image Upload closed -->

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">{{isset($category) ? 'Update': 'Create'}}</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- category form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
@endsection
@section('js')
<!--Internal Fileuploads js-->
<script src="{{URL::asset('assets/plugins/fileuploads/js/fileupload.js')}}"></script>
<script src="{{URL::asset('assets/plugins/fileuploads/js/file-upload.js')}}"></script>

@endsection