<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Workout extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'category_id',
        'overview',
        'slug',
        'description',
        'difficulty',
        'duration',
        'main_image',
        'video',
        'player_embed_url',
    ];

    public function category() {
        return $this->belongsTo(Category::class);
    }
    
}
