<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\Customer;
use App\Models\Category;
use App\Models\Activity;


class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        if(view()->exists($id)){
            return view($id);
        }
        else
        {
            return view('404');
        }

    }

    public function dashboard()
    {
        $customersCount = Customer::count();
        $categoriesCount = Category::count();
        $blogsCount = Blog::count();
        $workoutsCount = Activity::where('type_id', 1)->count();
        return view('index', compact('customersCount','categoriesCount', 'blogsCount', 'workoutsCount'));
    }

}
